/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.asyncqueue.internal;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class AsyncEventQueueStats
extends GatewaySenderStats {
    public static final String typeName = "AsyncEventQueueStatistics";
    private static final StatisticsType type;

    public AsyncEventQueueStats(StatisticsFactory f, String asyncQueueId) {
        super(f, asyncQueueId, type);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(typeName, "Stats for activity in the AsyncEventQueue", new StatisticDescriptor[]{f.createIntCounter("eventsReceived", "Number of events received by this queue.", "operations"), f.createIntCounter("eventsQueued", "Number of events added to the event queue.", "operations"), f.createLongCounter("eventQueueTime", "Total time spent queueing events.", "nanoseconds"), f.createIntGauge("eventQueueSize", "Size of the event queue.", "operations", false), f.createIntGauge("tempQueueSize", "Size of the temporary events queue.", "operations", false), f.createIntCounter("eventsNotQueuedConflated", "Number of events received but not added to the event queue because the queue already contains an event with the event's key.", "operations"), f.createIntCounter("eventsConflatedFromBatches", "Number of events conflated from batches.", "operations"), f.createIntCounter("eventsDistributed", "Number of events removed from the event queue and sent.", "operations"), f.createIntCounter("eventsExceedingAlertThreshold", "Number of events exceeding the alert threshold.", "operations", false), f.createLongCounter("batchDistributionTime", "Total time spent distributing batches of events to receivers.", "nanoseconds"), f.createIntCounter("batchesDistributed", "Number of batches of events removed from the event queue and sent.", "operations"), f.createIntCounter("batchesRedistributed", "Number of batches of events removed from the event queue and resent.", "operations", false), f.createIntCounter("unprocessedTokensAddedByPrimary", "Number of tokens added to the secondary's unprocessed token map by the primary (though a listener).", "tokens"), f.createIntCounter("unprocessedEventsAddedBySecondary", "Number of events added to the secondary's unprocessed event map by the secondary.", "events"), f.createIntCounter("unprocessedEventsRemovedByPrimary", "Number of events removed from the secondary's unprocessed event map by the primary (though a listener).", "events"), f.createIntCounter("unprocessedTokensRemovedBySecondary", "Number of tokens removed from the secondary's unprocessed token map by the secondary.", "tokens"), f.createIntCounter("unprocessedEventsRemovedByTimeout", "Number of events removed from the secondary's unprocessed event map by a timeout.", "events"), f.createIntCounter("unprocessedTokensRemovedByTimeout", "Number of tokens removed from the secondary's unprocessed token map by a timeout.", "tokens"), f.createIntGauge("unprocessedEventMapSize", "Current number of entries in the secondary's unprocessed event map.", "events", false), f.createIntGauge("unprocessedTokenMapSize", "Current number of entries in the secondary's unprocessed token map.", "tokens", false), f.createIntGauge("conflationIndexesSize", "Current number of entries in the conflation indexes map.", "events"), f.createIntCounter("notQueuedEvent", "Number of events not added to queue.", "events"), f.createIntCounter("eventsFiltered", "Number of events filtered through GatewayEventFilter.", "events"), f.createIntCounter("loadBalancesCompleted", "Number of load balances completed", "operations"), f.createIntGauge("loadBalancesInProgress", "Number of load balances in progress", "operations"), f.createLongCounter("loadBalanceTime", "Total time spent load balancing this sender", "nanoseconds"), f.createIntCounter("synchronizationEventsEnqueued", "Number of synchronization events added to the event queue.", "operations"), f.createIntCounter("synchronizationEventsProvided", "Number of synchronization events provided to other members.", "operations")});
        eventsReceivedId = type.nameToId("eventsReceived");
        eventsQueuedId = type.nameToId("eventsQueued");
        eventsNotQueuedConflatedId = type.nameToId("eventsNotQueuedConflated");
        eventQueueTimeId = type.nameToId("eventQueueTime");
        eventQueueSizeId = type.nameToId("eventQueueSize");
        eventTmpQueueSizeId = type.nameToId("tempQueueSize");
        eventsDistributedId = type.nameToId("eventsDistributed");
        eventsExceedingAlertThresholdId = type.nameToId("eventsExceedingAlertThreshold");
        batchDistributionTimeId = type.nameToId("batchDistributionTime");
        batchesDistributedId = type.nameToId("batchesDistributed");
        batchesRedistributedId = type.nameToId("batchesRedistributed");
        unprocessedTokensAddedByPrimaryId = type.nameToId("unprocessedTokensAddedByPrimary");
        unprocessedEventsAddedBySecondaryId = type.nameToId("unprocessedEventsAddedBySecondary");
        unprocessedEventsRemovedByPrimaryId = type.nameToId("unprocessedEventsRemovedByPrimary");
        unprocessedTokensRemovedBySecondaryId = type.nameToId("unprocessedTokensRemovedBySecondary");
        unprocessedEventsRemovedByTimeoutId = type.nameToId("unprocessedEventsRemovedByTimeout");
        unprocessedTokensRemovedByTimeoutId = type.nameToId("unprocessedTokensRemovedByTimeout");
        unprocessedEventMapSizeId = type.nameToId("unprocessedEventMapSize");
        unprocessedTokenMapSizeId = type.nameToId("unprocessedTokenMapSize");
        conflationIndexesMapSizeId = type.nameToId("conflationIndexesSize");
        notQueuedEventsId = type.nameToId("notQueuedEvent");
        eventsFilteredId = type.nameToId("eventsFiltered");
        eventsConflatedFromBatchesId = type.nameToId("eventsConflatedFromBatches");
        loadBalancesCompletedId = type.nameToId("loadBalancesCompleted");
        loadBalancesInProgressId = type.nameToId("loadBalancesInProgress");
        loadBalanceTimeId = type.nameToId("loadBalanceTime");
        synchronizationEventsEnqueuedId = type.nameToId("synchronizationEventsEnqueued");
        synchronizationEventsProvidedId = type.nameToId("synchronizationEventsProvided");
    }
}

