/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ResumptionAction
implements Serializable {
    private static final long serialVersionUID = 6632254151314915610L;
    public static final ResumptionAction NONE = new ResumptionAction("NONE");
    public static final ResumptionAction REINITIALIZE = new ResumptionAction("REINITIALIZE");
    private final transient String name;
    public final byte ordinal;
    private static byte nextOrdinal = 0;
    private static final ResumptionAction[] PRIVATE_VALUES = new ResumptionAction[]{NONE, REINITIALIZE};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));

    private Object readResolve() throws ObjectStreamException {
        return PRIVATE_VALUES[this.ordinal];
    }

    private ResumptionAction(String name) {
        byte by = nextOrdinal;
        nextOrdinal = (byte)(by + 1);
        this.ordinal = by;
        this.name = name;
    }

    public static ResumptionAction fromOrdinal(byte ordinal) {
        return PRIVATE_VALUES[ordinal];
    }

    public static ResumptionAction fromName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.ResumptionAction_INVALID_RESUMPTIONACTION_NAME_0.toLocalizedString(name));
        }
        for (int i = 0; i < PRIVATE_VALUES.length; ++i) {
            if (!name.equals(ResumptionAction.PRIVATE_VALUES[i].name)) continue;
            return PRIVATE_VALUES[i];
        }
        throw new IllegalArgumentException(LocalizedStrings.ResumptionAction_INVALID_RESUMPTIONACTION_NAME_0.toLocalizedString(name));
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isReinitialize() {
        return this == REINITIALIZE;
    }

    public String toString() {
        return this.name;
    }
}

