/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.SecurityConfig;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;

public class CacheFactory {
    private final Properties dsProps;
    private final CacheConfig cacheConfig = new CacheConfig();

    public CacheFactory() {
        this(null);
    }

    public CacheFactory(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.dsProps = props;
    }

    public CacheFactory set(String name, String value) {
        this.dsProps.setProperty(name, value);
        return this;
    }

    @Deprecated
    public static synchronized Cache create(DistributedSystem system) throws CacheExistsException, TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        return CacheFactory.create(system, false, new CacheConfig());
    }

    private static synchronized Cache create(DistributedSystem system, boolean existingOk, CacheConfig cacheConfig) throws CacheExistsException, TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        return GemFireCacheImpl.create((InternalDistributedSystem)system, existingOk, cacheConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache create() throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            DistributedSystem ds = null;
            if (this.dsProps.isEmpty()) {
                ds = InternalDistributedSystem.getConnectedInstance();
                this.validateUsabilityOfSecurityCallbacks(ds);
            }
            if (ds == null) {
                SecurityConfig.set(this.cacheConfig.getSecurityManager(), this.cacheConfig.getPostProcessor());
                try {
                    ds = DistributedSystem.connect(this.dsProps);
                }
                finally {
                    SecurityConfig.remove();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return CacheFactory.create(ds, true, this.cacheConfig);
        }
    }

    private void validateUsabilityOfSecurityCallbacks(DistributedSystem ds) throws GemFireSecurityException {
        if (ds == null) {
            return;
        }
        if (this.cacheConfig.getSecurityManager() != null) {
            throw new GemFireSecurityException("Existing DistributedSystem connection cannot use specified SecurityManager");
        }
        if (this.cacheConfig.getPostProcessor() != null) {
            throw new GemFireSecurityException("Existing DistributedSystem connection cannot use specified PostProcessor");
        }
    }

    public static Cache getInstance(DistributedSystem system) {
        return CacheFactory.basicGetInstance(system, false);
    }

    public static Cache getInstanceCloseOk(DistributedSystem system) {
        return CacheFactory.basicGetInstance(system, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache basicGetInstance(DistributedSystem system, boolean closeOk) {
        int initReq = LocalRegion.threadInitLevelRequirement();
        if (initReq == 2 || initReq == 1) {
            return CacheFactory.basicGetInstancePart2(system, closeOk);
        }
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return CacheFactory.basicGetInstancePart2(system, closeOk);
        }
    }

    private static Cache basicGetInstancePart2(DistributedSystem system, boolean closeOk) {
        GemFireCacheImpl instance = GemFireCacheImpl.getInstance();
        if (instance == null) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
        }
        if (instance.isClosed() && !closeOk) {
            throw instance.getCacheClosedException(LocalizedStrings.CacheFactory_THE_CACHE_HAS_BEEN_CLOSED.toLocalizedString(), null);
        }
        if (!instance.getDistributedSystem().equals(system)) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED_FOR_THE_GIVEN_DISTRIBUTED_SYSTEM.toLocalizedString());
        }
        return instance;
    }

    public static synchronized Cache getAnyInstance() {
        GemFireCacheImpl instance = GemFireCacheImpl.getInstance();
        if (instance == null) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
        }
        instance.getCancelCriterion().checkCancelInProgress(null);
        return instance;
    }

    public static String getVersion() {
        return GemFireVersion.getGemFireVersion();
    }

    public CacheFactory setPdxReadSerialized(boolean readSerialized) {
        this.cacheConfig.setPdxReadSerialized(readSerialized);
        return this;
    }

    public CacheFactory setSecurityManager(SecurityManager securityManager) {
        this.cacheConfig.setSecurityManager(securityManager);
        return this;
    }

    public CacheFactory setPostProcessor(PostProcessor postProcessor) {
        this.cacheConfig.setPostProcessor(postProcessor);
        return this;
    }

    public CacheFactory setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
        return this;
    }

    public CacheFactory setPdxDiskStore(String diskStoreName) {
        this.cacheConfig.setPdxDiskStore(diskStoreName);
        return this;
    }

    public CacheFactory setPdxPersistent(boolean isPersistent) {
        this.cacheConfig.setPdxPersistent(isPersistent);
        return this;
    }

    public CacheFactory setPdxIgnoreUnreadFields(boolean ignore) {
        this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
        return this;
    }
}

