/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.web.controllers.support.LoginHandlerInterceptor;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractCommandsController {
    private static final Logger logger = LogService.getLogger();
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String REST_API_VERSION = "/v1";
    private MemberMXBean managingMemberMXBeanProxy;
    private Class accessControlKlass;

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> internalError(Exception e) {
        String stackTrace = AbstractCommandsController.getPrintableStackTrace(e);
        logger.fatal(stackTrace);
        return new ResponseEntity((Object)stackTrace, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={AuthenticationFailedException.class})
    public ResponseEntity<String> unauthorized(AuthenticationFailedException e) {
        return new ResponseEntity((Object)e.getMessage(), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={NotAuthorizedException.class, SecurityException.class})
    public ResponseEntity<String> forbidden(Exception e) {
        return new ResponseEntity((Object)e.getMessage(), HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={MalformedObjectNameException.class})
    public ResponseEntity<String> badRequest(MalformedObjectNameException e) {
        logger.info((Object)e);
        return new ResponseEntity((Object)AbstractCommandsController.getPrintableStackTrace(e), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InstanceNotFoundException.class})
    public ResponseEntity<String> notFound(InstanceNotFoundException e) {
        logger.info((Object)e);
        return new ResponseEntity((Object)AbstractCommandsController.getPrintableStackTrace(e), HttpStatus.NOT_FOUND);
    }

    private static String getPrintableStackTrace(Throwable t) {
        StringWriter stackTraceWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stackTraceWriter));
        return stackTraceWriter.toString();
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(String[].class, (PropertyEditor)new StringArrayPropertyEditor(",", false));
    }

    protected MBeanServer getMBeanServer() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService((Cache)cache);
        ManagementAgent managementAgent = service.getManagementAgent();
        return managementAgent.getJmxConnectorServer().getMBeanServer();
    }

    private synchronized MemberMXBean getManagingMemberMXBean() {
        if (this.managingMemberMXBeanProxy == null) {
            MBeanServer mbs = this.getMBeanServer();
            DistributedSystemMXBean distributedSystemMXBean = JMX.newMXBeanProxy(mbs, MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
            this.managingMemberMXBeanProxy = this.createMemberMXBeanForManagerUsingProxy(mbs, distributedSystemMXBean.getMemberObjectName());
        }
        return this.managingMemberMXBeanProxy;
    }

    protected synchronized ObjectName getMemberObjectName() {
        MBeanServer platformMBeanServer = this.getMBeanServer();
        DistributedSystemMXBean distributedSystemMXBean = JMX.newMXBeanProxy(platformMBeanServer, MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
        return distributedSystemMXBean.getMemberObjectName();
    }

    private MemberMXBean createMemberMXBeanForManagerUsingProxy(MBeanServer server, ObjectName managingMemberObjectName) {
        return JMX.newMXBeanProxy(server, managingMemberObjectName, MemberMXBean.class);
    }

    protected Map<String, String> getEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.putAll(LoginHandlerInterceptor.getEnvironment());
        environment.put("APP_NAME", "gfsh");
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processCommand(String command, Map<String, String> environment, MultipartFile[] multipartFiles) throws IOException {
        ArrayList<String> filePaths = null;
        Path tempDir = null;
        if (multipartFiles != null) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            tempDir = Files.createTempDirectory("uploaded-", PosixFilePermissions.asFileAttribute(perms));
            filePaths = new ArrayList<String>();
            for (MultipartFile multipartFile : multipartFiles) {
                File dest = new File(tempDir.toFile(), multipartFile.getOriginalFilename());
                multipartFile.transferTo(dest);
                filePaths.add(dest.getAbsolutePath());
            }
        }
        MemberMXBean manager = this.getManagingMemberMXBean();
        try {
            MultipartFile[] multipartFileArray = manager.processCommand(command, environment, filePaths);
            return multipartFileArray;
        }
        finally {
            if (tempDir != null) {
                FileUtils.deleteDirectory((File)tempDir.toFile());
            }
        }
    }
}

