/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.utilities;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufUtilities;
import org.apache.geode.internal.protocol.state.exception.ConnectionStateException;

@Experimental
public abstract class ProtobufResponseUtilities {
    public static RegionAPI.GetRegionNamesResponse createGetRegionNamesResponse(Set<Region<?, ?>> regionSet) {
        RegionAPI.GetRegionNamesResponse.Builder builder = RegionAPI.GetRegionNamesResponse.newBuilder();
        for (Region<?, ?> region : regionSet) {
            builder.addRegions(region.getName());
        }
        return builder.build();
    }

    public static ClientProtocol.ErrorResponse makeErrorResponse(ProtocolErrorCode errorCode, String message) {
        return ClientProtocol.ErrorResponse.newBuilder().setError(BasicTypes.Error.newBuilder().setErrorCode(ProtobufUtilities.getProtobufErrorCode(errorCode)).setMessage(message)).build();
    }

    public static ClientProtocol.ErrorResponse makeErrorResponse(ConnectionStateException exception) {
        return ProtobufResponseUtilities.makeErrorResponse(exception.getErrorCode(), exception.getMessage());
    }
}

