/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.OperationContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ProtocolVersionHandler;
import org.apache.geode.internal.protocol.protobuf.v1.state.ConnectionShiroAuthenticatingStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.LegacySecurityConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.NoSecurityConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.exception.ConnectionStateException;
import org.apache.geode.internal.security.SecurityService;

public class ProtobufConnectionHandshakeStateProcessor
implements ConnectionStateProcessor {
    private final SecurityService securityService;

    public ProtobufConnectionHandshakeStateProcessor(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void validateOperation(MessageExecutionContext messageContext, OperationContext operationContext) throws ConnectionStateException {
        throw new ConnectionStateException(ProtocolErrorCode.INVALID_REQUEST, "Connection processing should never be asked to validate an operation");
    }

    private ConnectionStateProcessor nextConnectionState() {
        if (this.securityService.isIntegratedSecurity()) {
            return new ConnectionShiroAuthenticatingStateProcessor(this.securityService);
        }
        if (this.securityService.isPeerSecurityRequired() || this.securityService.isClientSecurityRequired()) {
            return new LegacySecurityConnectionStateProcessor();
        }
        return new NoSecurityConnectionStateProcessor();
    }

    public boolean handleMessageIndependently(InputStream inputStream, OutputStream outputStream, MessageExecutionContext executionContext) throws IOException {
        PushbackInputStream messageStream = new PushbackInputStream(inputStream);
        messageStream.unread(CommunicationMode.ProtobufClientServerProtocol.getModeNumber());
        if (ProtocolVersionHandler.handleVersionMessage(messageStream, outputStream, executionContext.getStatistics())) {
            executionContext.setConnectionStateProcessor(this.nextConnectionState());
        }
        return true;
    }
}

