/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.state;

import java.util.Properties;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.OperationContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.v1.operations.security.AuthenticationRequestOperationHandler;
import org.apache.geode.internal.protocol.state.ConnectionAuthenticatingStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionShiroAuthorizingStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.exception.ConnectionStateException;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.shiro.subject.Subject;

public class ConnectionShiroAuthenticatingStateProcessor
implements ConnectionAuthenticatingStateProcessor {
    private final SecurityService securityService;

    public ConnectionShiroAuthenticatingStateProcessor(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void validateOperation(MessageExecutionContext messageContext, OperationContext operationContext) throws ConnectionStateException {
        if (!(operationContext.getOperationHandler() instanceof AuthenticationRequestOperationHandler)) {
            throw new ConnectionStateException(ProtocolErrorCode.AUTHENTICATION_FAILED, "User has not yet authenticated");
        }
    }

    public ConnectionStateProcessor authenticate(Properties properties) throws AuthenticationFailedException {
        Subject subject = this.securityService.login(properties);
        return new ConnectionShiroAuthorizingStateProcessor(this.securityService, subject);
    }
}

