/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ConnectionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.LocatorAPI;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRegionNamesRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRegionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetServerOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.PutAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.PutRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.RemoveRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.security.AuthenticationRequestOperationHandler;
import org.apache.geode.security.ResourcePermission;

@Experimental
public class ProtobufOperationContextRegistry {
    private Map<ClientProtocol.Request.RequestAPICase, ProtobufOperationContext> operationContexts = new ConcurrentHashMap<ClientProtocol.Request.RequestAPICase, ProtobufOperationContext>();

    public ProtobufOperationContextRegistry() {
        this.addContexts();
    }

    public ProtobufOperationContext getOperationContext(ClientProtocol.Request.RequestAPICase apiCase) {
        return this.operationContexts.get(apiCase);
    }

    private void addContexts() {
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.AUTHENTICATIONREQUEST, new ProtobufOperationContext<ConnectionAPI.AuthenticationRequest, ConnectionAPI.AuthenticationResponse>(ClientProtocol.Request::getAuthenticationRequest, new AuthenticationRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setAuthenticationResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETREQUEST, new ProtobufOperationContext<RegionAPI.GetRequest, RegionAPI.GetResponse>(ClientProtocol.Request::getGetRequest, new GetRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETALLREQUEST, new ProtobufOperationContext<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse>(ClientProtocol.Request::getGetAllRequest, new GetAllRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetAllResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.PUTREQUEST, new ProtobufOperationContext<RegionAPI.PutRequest, RegionAPI.PutResponse>(ClientProtocol.Request::getPutRequest, new PutRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setPutResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.PUTALLREQUEST, new ProtobufOperationContext<RegionAPI.PutAllRequest, RegionAPI.PutAllResponse>(ClientProtocol.Request::getPutAllRequest, new PutAllRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setPutAllResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.REMOVEREQUEST, new ProtobufOperationContext<RegionAPI.RemoveRequest, RegionAPI.RemoveResponse>(ClientProtocol.Request::getRemoveRequest, new RemoveRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setRemoveResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETREGIONNAMESREQUEST, new ProtobufOperationContext<RegionAPI.GetRegionNamesRequest, RegionAPI.GetRegionNamesResponse>(ClientProtocol.Request::getGetRegionNamesRequest, new GetRegionNamesRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetRegionNamesResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETREGIONREQUEST, new ProtobufOperationContext<RegionAPI.GetRegionRequest, RegionAPI.GetRegionResponse>(ClientProtocol.Request::getGetRegionRequest, new GetRegionRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetRegionResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETSERVERREQUEST, new ProtobufOperationContext<LocatorAPI.GetServerRequest, LocatorAPI.GetServerResponse>(ClientProtocol.Request::getGetServerRequest, new GetServerOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetServerResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ)));
    }
}

