/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations.security;

import java.util.Map;
import java.util.Properties;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.Success;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ConnectionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.state.ConnectionAuthenticatingStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionTerminatingStateProcessor;
import org.apache.geode.internal.protocol.state.exception.ConnectionStateException;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthenticationRequestOperationHandler
implements ProtobufOperationHandler<ConnectionAPI.AuthenticationRequest, ConnectionAPI.AuthenticationResponse> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Result<ConnectionAPI.AuthenticationResponse, ClientProtocol.ErrorResponse> process(ProtobufSerializationService serializationService, ConnectionAPI.AuthenticationRequest request, MessageExecutionContext messageExecutionContext) throws ConnectionStateException {
        ConnectionAuthenticatingStateProcessor stateProcessor = messageExecutionContext.getConnectionStateProcessor().allowAuthentication();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)request.getCredentialsMap());
        try {
            ConnectionStateProcessor nextState = stateProcessor.authenticate(properties);
            messageExecutionContext.setConnectionStateProcessor(nextState);
            return Success.of((Object)ConnectionAPI.AuthenticationResponse.newBuilder().setAuthenticated(true).build());
        }
        catch (AuthenticationFailedException e) {
            messageExecutionContext.setConnectionStateProcessor((ConnectionStateProcessor)new ConnectionTerminatingStateProcessor());
            return Success.of((Object)ConnectionAPI.AuthenticationResponse.newBuilder().setAuthenticated(false).build());
        }
    }
}

