/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.Failure;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.Success;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.serialization.exception.EncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Experimental
public class RemoveRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.RemoveRequest, RegionAPI.RemoveResponse> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Result<RegionAPI.RemoveResponse, ClientProtocol.ErrorResponse> process(ProtobufSerializationService serializationService, RegionAPI.RemoveRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received Remove request for non-existing region {}", (Object)regionName);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.SERVER_ERROR, "Region not found"));
        }
        try {
            Object decodedKey = serializationService.decode(request.getKey());
            region.remove(decodedKey);
            return Success.of((Object)RegionAPI.RemoveResponse.newBuilder().build());
        }
        catch (EncodingException ex) {
            logger.error("Received Remove request with unsupported encoding: {}", (Throwable)ex);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.INVALID_REQUEST, "Encoding not supported: " + ex.getMessage()));
        }
    }
}

