/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.Failure;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.Success;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.serialization.exception.EncodingException;
import org.apache.logging.log4j.Logger;

@Experimental
public class PutRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.PutRequest, RegionAPI.PutResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.PutResponse, ClientProtocol.ErrorResponse> process(ProtobufSerializationService serializationService, RegionAPI.PutRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.warn("Received Put request for non-existing region: {}", (Object)regionName);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.SERVER_ERROR, "Region passed by client did not exist: " + regionName));
        }
        try {
            BasicTypes.Entry entry = request.getEntry();
            Object decodedValue = serializationService.decode(entry.getValue());
            Object decodedKey = serializationService.decode(entry.getKey());
            try {
                region.put(decodedKey, decodedValue);
                return Success.of((Object)RegionAPI.PutResponse.newBuilder().build());
            }
            catch (ClassCastException ex) {
                logger.error("Received Put request with invalid key type: {}", (Throwable)ex);
                return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.SERVER_ERROR, ex.toString()));
            }
        }
        catch (EncodingException ex) {
            logger.error("Got error when decoding Put request: {}", (Throwable)ex);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.INVALID_REQUEST, ex.toString()));
        }
    }
}

