/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.Failure;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.Success;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufUtilities;
import org.apache.geode.internal.protocol.serialization.SerializationService;
import org.apache.geode.internal.protocol.serialization.exception.EncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Experimental
public class PutAllRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.PutAllRequest, RegionAPI.PutAllResponse> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Result<RegionAPI.PutAllResponse, ClientProtocol.ErrorResponse> process(ProtobufSerializationService serializationService, RegionAPI.PutAllRequest putAllRequest, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        String regionName = putAllRequest.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received PutAll request for non-existing region {}", (Object)regionName);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.SERVER_ERROR, "Region passed does not exist: " + regionName));
        }
        RegionAPI.PutAllResponse.Builder builder = RegionAPI.PutAllResponse.newBuilder().addAllFailedKeys((Iterable)putAllRequest.getEntryList().stream().map(entry -> this.singlePut(serializationService, region, (BasicTypes.Entry)entry)).filter(Objects::nonNull).collect(Collectors.toList()));
        return Success.of((Object)builder.build());
    }

    private BasicTypes.KeyedError singlePut(SerializationService serializationService, Region region, BasicTypes.Entry entry) {
        try {
            Object decodedValue = serializationService.decode((Object)entry.getValue());
            Object decodedKey = serializationService.decode((Object)entry.getKey());
            region.put(decodedKey, decodedValue);
        }
        catch (EncodingException ex) {
            return this.buildAndLogKeyedError(entry, ProtocolErrorCode.INVALID_REQUEST, "Encoding not supported", (Exception)((Object)ex));
        }
        catch (ClassCastException ex) {
            return this.buildAndLogKeyedError(entry, ProtocolErrorCode.SERVER_ERROR, ex.toString(), ex);
        }
        return null;
    }

    private BasicTypes.KeyedError buildAndLogKeyedError(BasicTypes.Entry entry, ProtocolErrorCode errorCode, String message, Exception ex) {
        logger.error(message, (Throwable)ex);
        return BasicTypes.KeyedError.newBuilder().setKey(entry.getKey()).setError(BasicTypes.Error.newBuilder().setErrorCode(ProtobufUtilities.getProtobufErrorCode(errorCode)).setMessage(message)).build();
    }
}

