/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geode.internal.protocol.protobuf.ProtocolVersion;
import org.apache.geode.internal.protocol.protobuf.v1.operations.VersionValidator;
import org.apache.geode.internal.protocol.statistics.ProtocolClientStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProtocolVersionHandler {
    private static final Logger logger = LogManager.getLogger();
    private static final VersionValidator validator = new VersionValidator();

    public static boolean handleVersionMessage(InputStream inputStream, OutputStream outputStream, ProtocolClientStatistics statistics) throws IOException {
        ProtocolVersion.NewConnectionClientVersion versionMessage = ProtocolVersion.NewConnectionClientVersion.parseDelimitedFrom((InputStream)inputStream);
        statistics.messageReceived(versionMessage.getSerializedSize());
        boolean versionAccepted = validator.isValid(versionMessage.getMajorVersion(), versionMessage.getMinorVersion());
        ProtocolVersion.VersionAcknowledgement handshakeResponse = ProtocolVersion.VersionAcknowledgement.newBuilder().setServerMajorVersion(1).setServerMinorVersion(1).setVersionAccepted(versionAccepted).build();
        handshakeResponse.writeDelimitedTo(outputStream);
        statistics.messageSent(handshakeResponse.getSerializedSize());
        if (!versionAccepted) {
            throw new IOException("Incompatible protobuf version.");
        }
        return versionAccepted;
    }
}

