/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.HashSet;
import java.util.List;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientConnectionResponse;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.Failure;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.Success;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.LocatorAPI;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.state.ConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionTerminatingStateProcessor;

@Experimental
public class GetServerOperationHandler
implements ProtobufOperationHandler<LocatorAPI.GetServerRequest, LocatorAPI.GetServerResponse> {
    @Override
    public Result<LocatorAPI.GetServerResponse, ClientProtocol.ErrorResponse> process(ProtobufSerializationService serializationService, LocatorAPI.GetServerRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        HashSet<ServerLocation> excludedServers = new HashSet<ServerLocation>();
        List excludedServersList = request.getExcludedServersList();
        for (BasicTypes.Server server : excludedServersList) {
            excludedServers.add(new ServerLocation(server.getHostname(), server.getPort()));
        }
        String serverGroup = request.getServerGroup();
        messageExecutionContext.setConnectionStateProcessor((ConnectionStateProcessor)new ConnectionTerminatingStateProcessor());
        InternalLocator internalLocator = (InternalLocator)messageExecutionContext.getLocator();
        ClientConnectionRequest clientConnectionRequest = new ClientConnectionRequest(excludedServers, serverGroup);
        ClientConnectionResponse connectionResponse = (ClientConnectionResponse)internalLocator.getServerLocatorAdvisee().processRequest((Object)clientConnectionRequest);
        ServerLocation serverLocation = null;
        if (connectionResponse != null) {
            serverLocation = connectionResponse.getServer();
        }
        if (serverLocation == null) {
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.NO_AVAILABLE_SERVER, "Unable to find a server for you"));
        }
        LocatorAPI.GetServerResponse.Builder builder = LocatorAPI.GetServerResponse.newBuilder();
        BasicTypes.Server.Builder serverBuilder = BasicTypes.Server.newBuilder();
        serverBuilder.setHostname(serverLocation.getHostName()).setPort(serverLocation.getPort());
        BasicTypes.Server server = serverBuilder.build();
        builder.setServer(server);
        return Success.of((Object)builder.build());
    }
}

