/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.Failure;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.Success;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.serialization.exception.EncodingException;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetRequest, RegionAPI.GetResponse> {
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<RegionAPI.GetResponse, ClientProtocol.ErrorResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received Get request for non-existing region {}", (Object)regionName);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.SERVER_ERROR, "Region not found"));
        }
        try {
            ((InternalCache)messageExecutionContext.getCache()).setReadSerializedForCurrentThread(true);
            Object decodedKey = serializationService.decode(request.getKey());
            Object resultValue = region.get(decodedKey);
            if (resultValue == null) {
                Success success = Success.of((Object)RegionAPI.GetResponse.newBuilder().build());
                return success;
            }
            BasicTypes.EncodedValue encodedValue = serializationService.encode(resultValue);
            Success success = Success.of((Object)RegionAPI.GetResponse.newBuilder().setResult(encodedValue).build());
            return success;
        }
        catch (EncodingException ex) {
            logger.error("Received Get request with unsupported encoding: {}", (Throwable)ex);
            Failure failure = Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.INVALID_REQUEST, "Encoding not supported."));
            return failure;
        }
        finally {
            ((InternalCache)messageExecutionContext.getCache()).setReadSerializedForCurrentThread(false);
        }
    }
}

