/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.Failure;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.Success;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufUtilities;
import org.apache.geode.internal.protocol.serialization.exception.EncodingException;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetAllRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse> {
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<RegionAPI.GetAllResponse, ClientProtocol.ErrorResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetAllRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        Map<Boolean, List<Object>> resultsCollection;
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received GetAll request for non-existing region {}", (Object)regionName);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.SERVER_ERROR, "Region not found"));
        }
        try {
            ((InternalCache)messageExecutionContext.getCache()).setReadSerializedForCurrentThread(true);
            resultsCollection = request.getKeyList().stream().map(key -> this.processOneMessage(serializationService, region, (BasicTypes.EncodedValue)key)).collect(Collectors.partitioningBy(x -> x instanceof BasicTypes.Entry));
        }
        finally {
            ((InternalCache)messageExecutionContext.getCache()).setReadSerializedForCurrentThread(false);
        }
        RegionAPI.GetAllResponse.Builder responseBuilder = RegionAPI.GetAllResponse.newBuilder();
        for (Object entry : resultsCollection.get(true)) {
            responseBuilder.addEntries((BasicTypes.Entry)entry);
        }
        for (Object entry : resultsCollection.get(false)) {
            responseBuilder.addFailures((BasicTypes.KeyedError)entry);
        }
        return Success.of((Object)responseBuilder.build());
    }

    private Object processOneMessage(ProtobufSerializationService serializationService, Region region, BasicTypes.EncodedValue key) {
        try {
            Object decodedKey = serializationService.decode(key);
            Object value = region.get(decodedKey);
            return ProtobufUtilities.createEntry(serializationService, decodedKey, value);
        }
        catch (EncodingException ex) {
            logger.error("Encoding not supported: {}", (Throwable)ex);
            return this.createKeyedError(key, "Encoding not supported.", ProtocolErrorCode.INVALID_REQUEST);
        }
        catch (Exception ex) {
            logger.error("Failure in protobuf getAll operation for key: " + key, (Throwable)ex);
            return this.createKeyedError(key, ex.toString(), ProtocolErrorCode.SERVER_ERROR);
        }
    }

    private Object createKeyedError(BasicTypes.EncodedValue key, String errorMessage, ProtocolErrorCode errorCode) {
        return BasicTypes.KeyedError.newBuilder().setKey(key).setError(BasicTypes.Error.newBuilder().setErrorCode(ProtobufUtilities.getProtobufErrorCode(errorCode)).setMessage(errorMessage)).build();
    }
}

