/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.ClientProtocolMessageHandler;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.exception.InvalidProtocolMessageException;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOpsProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.registry.ProtobufOperationContextRegistry;
import org.apache.geode.internal.protocol.protobuf.v1.serializer.ProtobufProtocolSerializer;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufUtilities;
import org.apache.geode.internal.protocol.statistics.ProtocolClientStatistics;
import org.apache.logging.log4j.Logger;

@Experimental
public class ProtobufStreamProcessor
implements ClientProtocolMessageHandler {
    private final ProtobufProtocolSerializer protobufProtocolSerializer = new ProtobufProtocolSerializer();
    private final ProtobufOpsProcessor protobufOpsProcessor = new ProtobufOpsProcessor(new ProtobufSerializationService(), new ProtobufOperationContextRegistry());
    private static final Logger logger = LogService.getLogger();

    public void receiveMessage(InputStream inputStream, OutputStream outputStream, MessageExecutionContext executionContext) throws IOException {
        try {
            this.processOneMessage(inputStream, outputStream, executionContext);
        }
        catch (InvalidProtocolMessageException e) {
            throw new IOException(e);
        }
    }

    private void processOneMessage(InputStream inputStream, OutputStream outputStream, MessageExecutionContext executionContext) throws InvalidProtocolMessageException, IOException {
        if (executionContext.getConnectionStateProcessor().handleMessageIndependently(inputStream, outputStream, executionContext)) {
            return;
        }
        ClientProtocol.Message message = this.protobufProtocolSerializer.deserialize(inputStream);
        if (message == null) {
            String errorMessage = "Tried to deserialize protobuf message at EOF";
            logger.debug(errorMessage);
            throw new EOFException(errorMessage);
        }
        ProtocolClientStatistics statistics = executionContext.getStatistics();
        statistics.messageReceived(message.getSerializedSize());
        ClientProtocol.Request request = message.getRequest();
        ClientProtocol.Response response = this.protobufOpsProcessor.process(request, executionContext);
        ClientProtocol.Message responseMessage = ProtobufUtilities.createProtobufResponse(response);
        statistics.messageSent(responseMessage.getSerializedSize());
        this.protobufProtocolSerializer.serialize(responseMessage, outputStream);
    }
}

