/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import com.google.protobuf.ByteString;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.exception.UnknownProtobufEncodingType;
import org.apache.geode.internal.protocol.serialization.JsonPdxConverter;
import org.apache.geode.internal.protocol.serialization.SerializationService;
import org.apache.geode.internal.protocol.serialization.exception.EncodingException;
import org.apache.geode.pdx.PdxInstance;

@Experimental
public class ProtobufSerializationService
implements SerializationService<BasicTypes.EncodedValue> {
    private final JsonPdxConverter jsonPdxConverter = new JsonPdxConverter();

    public BasicTypes.EncodedValue encode(Object value) throws EncodingException {
        BasicTypes.EncodedValue.Builder builder = BasicTypes.EncodedValue.newBuilder();
        try {
            ProtobufEncodingTypes protobufEncodingTypes = ProtobufEncodingTypes.valueOf(value.getClass());
            switch (protobufEncodingTypes) {
                case INT: {
                    builder.setIntResult(((Integer)value).intValue());
                    break;
                }
                case LONG: {
                    builder.setLongResult(((Long)value).longValue());
                    break;
                }
                case SHORT: {
                    builder.setShortResult((int)((Short)value).shortValue());
                    break;
                }
                case BYTE: {
                    builder.setByteResult((int)((Byte)value).byteValue());
                    break;
                }
                case DOUBLE: {
                    builder.setDoubleResult(((Double)value).doubleValue());
                    break;
                }
                case FLOAT: {
                    builder.setFloatResult(((Float)value).floatValue());
                    break;
                }
                case BINARY: {
                    builder.setBinaryResult(ByteString.copyFrom((byte[])((byte[])value)));
                    break;
                }
                case BOOLEAN: {
                    builder.setBooleanResult(((Boolean)value).booleanValue());
                    break;
                }
                case STRING: {
                    builder.setStringResult((String)value);
                    break;
                }
                case PDX_OBJECT: {
                    builder.setJsonObjectResult(this.jsonPdxConverter.encode((PdxInstance)value));
                }
            }
        }
        catch (UnknownProtobufEncodingType unknownProtobufEncodingType) {
            throw new EncodingException("No protobuf encoding for type " + value.getClass().getName());
        }
        return builder.build();
    }

    public Object decode(BasicTypes.EncodedValue encodedValue) throws EncodingException {
        switch (encodedValue.getValueCase()) {
            case BINARYRESULT: {
                return encodedValue.getBinaryResult().toByteArray();
            }
            case BOOLEANRESULT: {
                return encodedValue.getBooleanResult();
            }
            case BYTERESULT: {
                return (byte)encodedValue.getByteResult();
            }
            case DOUBLERESULT: {
                return encodedValue.getDoubleResult();
            }
            case FLOATRESULT: {
                return Float.valueOf(encodedValue.getFloatResult());
            }
            case INTRESULT: {
                return encodedValue.getIntResult();
            }
            case LONGRESULT: {
                return encodedValue.getLongResult();
            }
            case SHORTRESULT: {
                return (short)encodedValue.getShortResult();
            }
            case STRINGRESULT: {
                return encodedValue.getStringResult();
            }
            case JSONOBJECTRESULT: {
                return this.jsonPdxConverter.decode(encodedValue.getJsonObjectResult());
            }
            case VALUE_NOT_SET: {
                return null;
            }
        }
        throw new EncodingException("Unknown Protobuf encoding type: " + encodedValue.getValueCase());
    }

    private static enum ProtobufEncodingTypes {
        STRING(String.class),
        INT(Integer.class),
        LONG(Long.class),
        SHORT(Short.class),
        BYTE(Byte.class),
        BOOLEAN(Boolean.class),
        DOUBLE(Double.class),
        FLOAT(Float.class),
        BINARY(byte[].class),
        PDX_OBJECT(PdxInstance.class);

        private Class clazz;

        private ProtobufEncodingTypes(Class clazz) {
            this.clazz = clazz;
        }

        public static ProtobufEncodingTypes valueOf(Class unencodedValueClass) throws UnknownProtobufEncodingType {
            for (ProtobufEncodingTypes protobufEncodingTypes : ProtobufEncodingTypes.values()) {
                if (!protobufEncodingTypes.clazz.isAssignableFrom(unencodedValueClass)) continue;
                return protobufEncodingTypes;
            }
            throw new UnknownProtobufEncodingType("There is no primitive protobuf type mapping for class:" + unencodedValueClass);
        }
    }
}

