/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.Failure;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.OperationContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.Result;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.registry.ProtobufOperationContextRegistry;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.serialization.SerializationService;
import org.apache.geode.internal.protocol.state.ConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionTerminatingStateProcessor;
import org.apache.geode.internal.protocol.state.exception.ConnectionStateException;
import org.apache.geode.internal.protocol.state.exception.OperationNotAuthorizedException;
import org.apache.logging.log4j.Logger;

@Experimental
public class ProtobufOpsProcessor {
    private final ProtobufOperationContextRegistry protobufOperationContextRegistry;
    private final SerializationService serializationService;
    private static final Logger logger = LogService.getLogger(ProtobufOpsProcessor.class);

    public ProtobufOpsProcessor(SerializationService serializationService, ProtobufOperationContextRegistry protobufOperationContextRegistry) {
        this.serializationService = serializationService;
        this.protobufOperationContextRegistry = protobufOperationContextRegistry;
    }

    public ClientProtocol.Response process(ClientProtocol.Request request, MessageExecutionContext messageExecutionContext) {
        Failure result;
        ClientProtocol.Request.RequestAPICase requestType = request.getRequestAPICase();
        logger.debug("Processing request of type {}", (Object)requestType);
        ProtobufOperationContext operationContext = this.protobufOperationContextRegistry.getOperationContext(requestType);
        try {
            messageExecutionContext.getConnectionStateProcessor().validateOperation(messageExecutionContext, (OperationContext)operationContext);
            result = this.processOperation(request, messageExecutionContext, requestType, operationContext);
        }
        catch (OperationNotAuthorizedException e) {
            logger.warn(e.getMessage());
            result = Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse((ConnectionStateException)((Object)e)));
        }
        catch (ConnectionStateException e) {
            logger.warn(e.getMessage());
            messageExecutionContext.setConnectionStateProcessor((ConnectionStateProcessor)new ConnectionTerminatingStateProcessor());
            result = Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(e));
        }
        return ((ClientProtocol.Response.Builder)result.map(operationContext.getToResponse(), operationContext.getToErrorResponse())).build();
    }

    private Result processOperation(ClientProtocol.Request request, MessageExecutionContext context, ClientProtocol.Request.RequestAPICase requestType, OperationContext operationContext) throws ConnectionStateException {
        try {
            return operationContext.getOperationHandler().process((Object)this.serializationService, operationContext.getFromRequest().apply(request), context);
        }
        catch (InvalidExecutionContextException exception) {
            logger.error("Invalid execution context found for operation {}", (Object)requestType);
            return Failure.of((Object)ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.INVALID_REQUEST, "Invalid execution context found for operation."));
        }
    }
}

