/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolProcessor;
import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufStreamProcessor;
import org.apache.geode.internal.protocol.statistics.ProtocolClientStatistics;

@Experimental
public final class ProtobufCachePipeline
implements ClientProtocolProcessor {
    private final ProtocolClientStatistics statistics;
    private final ProtobufStreamProcessor streamProcessor;
    private final MessageExecutionContext messageExecutionContext;

    ProtobufCachePipeline(ProtobufStreamProcessor protobufStreamProcessor, MessageExecutionContext context) {
        this.streamProcessor = protobufStreamProcessor;
        this.statistics = context.getStatistics();
        this.statistics.clientConnected();
        this.messageExecutionContext = context;
    }

    public void processMessage(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.streamProcessor.receiveMessage(inputStream, outputStream, this.messageExecutionContext);
    }

    public void close() {
        this.statistics.clientDisconnected();
    }

    public boolean socketProcessingIsFinished() {
        return this.messageExecutionContext.getConnectionStateProcessor().socketProcessingIsFinished();
    }
}

