/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.state;

import org.apache.geode.internal.protocol.MessageExecutionContext;
import org.apache.geode.internal.protocol.OperationContext;
import org.apache.geode.internal.protocol.ProtocolErrorCode;
import org.apache.geode.internal.protocol.state.ConnectionAuthenticatingStateProcessor;
import org.apache.geode.internal.protocol.state.ConnectionStateProcessor;
import org.apache.geode.internal.protocol.state.exception.ConnectionStateException;
import org.apache.geode.internal.protocol.state.exception.OperationNotAuthorizedException;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;

public class ConnectionShiroAuthorizingStateProcessor
implements ConnectionStateProcessor {
    private final SecurityService securityService;
    private final Subject subject;

    public ConnectionShiroAuthorizingStateProcessor(SecurityService securityService, Subject subject) {
        this.securityService = securityService;
        this.subject = subject;
    }

    @Override
    public void validateOperation(MessageExecutionContext messageContext, OperationContext operationContext) throws ConnectionStateException {
        ThreadState threadState = this.securityService.bindSubject(this.subject);
        try {
            this.securityService.authorize(operationContext.getAccessPermissionRequired());
        }
        catch (NotAuthorizedException e) {
            messageContext.getStatistics().incAuthorizationViolations();
            throw new OperationNotAuthorizedException(ProtocolErrorCode.AUTHORIZATION_FAILED, "The user is not authorized to complete this operation");
        }
        finally {
            threadState.restore();
        }
    }

    @Override
    public ConnectionAuthenticatingStateProcessor allowAuthentication() throws ConnectionStateException {
        throw new ConnectionStateException(ProtocolErrorCode.ALREADY_AUTHENTICATED, "The user has already been authenticated for this connection. Re-authentication is not supported at this time.");
    }
}

