/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.serialization;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.serialization.SerializationType;
import org.apache.geode.internal.protocol.serialization.TypeConverter;
import org.apache.geode.internal.protocol.serialization.exception.EncodingException;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.JSONFormatterException;
import org.apache.geode.pdx.PdxInstance;

@Experimental
public class JsonPdxConverter
implements TypeConverter<String, PdxInstance> {
    @Override
    public PdxInstance decode(String incoming) throws EncodingException {
        try {
            return JSONFormatter.fromJSON((String)incoming);
        }
        catch (JSONFormatterException ex) {
            throw new EncodingException("Could not decode JSON-encoded object ", ex);
        }
    }

    @Override
    public String encode(PdxInstance incoming) throws EncodingException {
        try {
            return JSONFormatter.toJSON((PdxInstance)incoming);
        }
        catch (JSONFormatterException ex) {
            throw new EncodingException("Could not encode PDX object as JSON", ex);
        }
    }

    @Override
    public SerializationType getSerializationType() {
        return SerializationType.JSON;
    }
}

