/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol;

import java.util.function.Function;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.security.ResourcePermission;

@Experimental
public abstract class OperationContext<OperationRequest, OperationResponse, ErrorResponse, ProtocolRequest, ProtocolResponse, Serializer> {
    private final OperationHandler<OperationRequest, OperationResponse, ErrorResponse, Serializer> operationHandler;
    private final Function<ProtocolRequest, OperationRequest> fromRequest;
    private final Function<OperationResponse, ProtocolResponse> toResponse;
    private final Function<ErrorResponse, ProtocolResponse> toErrorResponse;
    private final ResourcePermission accessPermissionRequired;

    public OperationContext(Function<ProtocolRequest, OperationRequest> fromRequest, OperationHandler<OperationRequest, OperationResponse, ErrorResponse, Serializer> operationHandler, Function<OperationResponse, ProtocolResponse> toResponse, ResourcePermission permissionRequired) {
        this.operationHandler = operationHandler;
        this.fromRequest = fromRequest;
        this.toResponse = toResponse;
        this.toErrorResponse = this::makeErrorBuilder;
        this.accessPermissionRequired = permissionRequired;
    }

    protected abstract ProtocolResponse makeErrorBuilder(ErrorResponse var1);

    public OperationHandler<OperationRequest, OperationResponse, ErrorResponse, Serializer> getOperationHandler() {
        return this.operationHandler;
    }

    public Function<ProtocolRequest, OperationRequest> getFromRequest() {
        return this.fromRequest;
    }

    public Function<OperationResponse, ProtocolResponse> getToResponse() {
        return this.toResponse;
    }

    public Function<ErrorResponse, ProtocolResponse> getToErrorResponse() {
        return this.toErrorResponse;
    }

    public ResourcePermission getAccessPermissionRequired() {
        return this.accessPermissionRequired;
    }
}

