/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.sequence;

import java.awt.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.*;

/**
 * Created by IntelliJ IDEA. User: dsmith Date: Oct 29, 2010 Time: 5:24:54 PM To change this
 * template use File | Settings | File Templates.
 */
public class TimeAxis extends JComponent {
  public static final int HORIZONTAL = 0;
  public static final int VERTICAL = 1;
  public static final int SIZE = 100;
  private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");

  public int orientation;
  private long minTime;
  private long maxTime;

  public TimeAxis(int orientation, long minTime, long maxTime) {
    this.orientation = orientation;
    this.minTime = minTime;
    this.maxTime = maxTime;
  }

  public void setPreferredHeight(int ph) {
    setPreferredSize(new Dimension(SIZE, ph));
  }

  public void setPreferredWidth(int pw) {
    setPreferredSize(new Dimension(pw, SIZE));
  }

  protected void paintComponent(Graphics g) {
    Rectangle drawHere = g.getClipBounds();

    int height = getHeight();

    double scale = (maxTime - minTime) / height;
    int increment = 30;
    // Fill clipping area with dirty brown/orange.
    g.setColor(new Color(230, 163, 4));
    g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);

    // Do the ruler labels in a small font that's black.
    g.setFont(new Font("SansSerif", Font.PLAIN, 10));
    g.setColor(Color.black);

    // Some vars we need.
    int end = 0;
    int start = 0;
    int tickLength = 0;
    String text = null;

    // Use clipping bounds to calculate first and last tick locations.
    if (orientation == HORIZONTAL) {
      start = (drawHere.x / increment) * increment;
      end = (((drawHere.x + drawHere.width) / increment) + 1) * increment;
    } else {
      start = (drawHere.y / increment) * increment;
      end = (((drawHere.y + drawHere.height) / increment) + 1) * increment;
    }

    // Make a special case of 0 to display the number
    // within the rule and draw a units label.
    if (start == 0) {
      text = DATE_FORMAT.format(new Date(minTime));
      tickLength = 10;
      if (orientation == HORIZONTAL) {
        g.drawLine(0, SIZE - 1, 0, SIZE - tickLength - 1);
        g.drawString(text, 2, 21);
      } else {
        g.drawLine(SIZE - 1, 0, SIZE - tickLength - 1, 0);
        g.drawString(text, 9, 10);
      }
      text = null;
      start = increment;
    }

    // ticks and labels
    for (int i = start; i < end; i += increment) {
      tickLength = 10;
      text = DATE_FORMAT.format(new Date((long) (minTime + i * scale)));

      if (tickLength != 0) {
        if (orientation == HORIZONTAL) {
          g.drawLine(i, SIZE - 1, i, SIZE - tickLength - 1);
          if (text != null)
            g.drawString(text, i - 3, 21);
        } else {
          g.drawLine(SIZE - 1, i, SIZE - tickLength - 1, i);
          if (text != null)
            g.drawString(text, 9, i + 3);
        }
      }
    }
  }
}
