/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.internal.concurrent;

/**
 * These methods are the same ones on the JDK 5 version java.util.concurrent.atomic.AtomicLong. Note
 * that unlike AtomicLong this interface does not support <code>java.lang.Number</code>.
 *
 * @deprecated used AtomicLong instead
 */
public interface AL {
  /**
   * Gets the current value.
   *
   * @return the current value
   */
  public long get();

  /**
   * Sets to the given value.
   *
   * @param newValue the new value
   */
  public void set(long newValue);

  /**
   * Atomically sets to the given value and returns the old value.
   *
   * @param newValue the new value
   * @return the previous value
   */
  public long getAndSet(long newValue);

  /**
   * Atomically sets the value to the given updated value if the current value {@code ==} the
   * expected value.
   *
   * @param expect the expected value
   * @param update the new value
   * @return true if successful. False return indicates that the actual value was not equal to the
   *         expected value.
   */
  public boolean compareAndSet(long expect, long update);

  /**
   * Atomically sets the value to the given updated value if the current value {@code ==} the
   * expected value.
   *
   * <p>
   * May <a href="package-summary.html#Spurious">fail spuriously</a> and does not provide ordering
   * guarantees, so is only rarely an appropriate alternative to {@code compareAndSet}.
   *
   * @param expect the expected value
   * @param update the new value
   * @return true if successful.
   */
  public boolean weakCompareAndSet(long expect, long update);

  /**
   * Atomically increments by one the current value.
   *
   * @return the previous value
   */
  public long getAndIncrement();

  /**
   * Atomically decrements by one the current value.
   *
   * @return the previous value
   */
  public long getAndDecrement();

  /**
   * Atomically adds the given value to the current value.
   *
   * @param delta the value to add
   * @return the previous value
   */
  public long getAndAdd(long delta);

  /**
   * Atomically increments by one the current value.
   *
   * @return the updated value
   */
  public long incrementAndGet();

  /**
   * Atomically decrements by one the current value.
   *
   * @return the updated value
   */
  public long decrementAndGet();

  /**
   * Atomically adds the given value to the current value.
   *
   * @param delta the value to add
   * @return the updated value
   */
  public long addAndGet(long delta);

  /**
   * Atomically sets the value to the given updated value if the given value {@code >} the current
   * value. This could be sub-optimat when the update being done by multiple thread is not in in an
   * incremental fashion.
   *
   * @param update
   */
  public boolean setIfGreater(long update);
}
