/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package org.apache.geode.distributed.internal;

import org.apache.geode.admin.GemFireHealth;

/**
 * Represents a thread that monitor the health of the vm it lives in.
 *
 * @since GemFire 3.5
 */
public interface HealthMonitor {
  /**
   * Returns the id of this monitor instance. Each instance is given a unique id when it is created.
   */
  public int getId();

  /**
   * Resets the current health status to zero.
   */
  public void resetStatus();

  /**
   * Returns the diagnosis of the desired status.
   */
  public String[] getDiagnosis(GemFireHealth.Health healthCode);

  /**
   * Stops the monitor so it no longer checks for health. Once stopped a monitor can not be started.
   */
  public void stop();
}
