/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.test.concurrency.jpf.peers;

import gov.nasa.jpf.annotation.MJI;
import gov.nasa.jpf.vm.MJIEnv;
import gov.nasa.jpf.vm.NativePeer;

/**
 * MJI class to make ReentrantReadWriteLock work with later versions of Java 8.
 *
 * The issue is that ReentrantReadWriteLock uses unsafe find a thread id, but JPF's thread class is
 * different than the JDK.
 *
 * This class allows us to use the JDK's ReentrantReadWriteLock by overriding the behavior to get
 * the thread id.
 */
public class JPF_java_util_concurrent_locks_ReentrantReadWriteLock extends NativePeer {

  @MJI
  public void $clinit____V(MJIEnv env, int clsObjRef) {
    // Overriding the JDK's class initialization which looks up the location of
    // the tid field on Thread.class
  }

  @MJI
  public long getThreadId(MJIEnv env, int clsObjRef, int rThread0) {
    return env.getThreadInfoForObjRef(rThread0).getId();
  }
}
