/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/storage/providers/LocalStorageProvider.as
 * org.apache.flex.storage.providers.LocalStorageProvider
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.storage.providers.LocalStorageProvider');

goog.require('org.apache.flex.storage.IWebStorage');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @constructor
 * @implements {org.apache.flex.storage.IWebStorage}
 */
org.apache.flex.storage.providers.LocalStorageProvider = function() {
  
};


/**
 * Returns true if the platform provides local storage.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @return {boolean}
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.storageAvailable = function() {
  var /** @type {boolean} */ result = false;
  
  try {
    result = 'localStorage' in window && window['localStorage'] !== null;
  } catch (e) {
    result = false;
  }
  return result;
};


/**
 * Stores a value with a key.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @param {string} value
 * @return {boolean}
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.setItem = function(key, value) {
  if (!this.storageAvailable())
    return false;
  
  window.localStorage.setItem(key, value);
  return true;
};


/**
 * Returns the value associated with the key, or undefined if there is
 * no value stored. Note that a String version of the value is stored.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @return {string}
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.getItem = function(key) {
  if (!this.storageAvailable())
    return null;
  var /** @type {string} */ result = null;
  
  result = window.localStorage.getItem(key);
  return result;
};


/**
 * Removed the value and, possibly, the key from local storage. On some
 * platforms, retriving the value after removing it will be an error, on
 * others it may return undefined or null.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @return {boolean}
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.removeItem = function(key) {
  if (!this.storageAvailable())
    return null;
  
  window.localStorage.removeItem(key);
  return true;
};


/**
 * Returns true if there is a value stored for the key.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @return {boolean}
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.hasItem = function(key) {
  if (!this.storageAvailable())
    return false;
  var /** @type {boolean} */ result = false;
  
  result = (window.localStorage[key] !== null);
  return result;
};


/**
 * Clears all values from local storage.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.clear = function() {
  if (!this.storageAvailable())
    return;
  
  window.localStorage.clear();
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LocalStorageProvider', qName: 'org.apache.flex.storage.providers.LocalStorageProvider'}], interfaces: [org.apache.flex.storage.IWebStorage] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.storage.providers.LocalStorageProvider', org.apache.flex.storage.providers.LocalStorageProvider);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.storage.providers.LocalStorageProvider.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'LocalStorageProvider': { type: '', declaredBy: 'org.apache.flex.storage.providers.LocalStorageProvider'},
        'storageAvailable': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.providers.LocalStorageProvider'},
        'setItem': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.providers.LocalStorageProvider'},
        'getItem': { type: 'String', declaredBy: 'org.apache.flex.storage.providers.LocalStorageProvider'},
        'removeItem': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.providers.LocalStorageProvider'},
        'hasItem': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.providers.LocalStorageProvider'},
        'clear': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.LocalStorageProvider'}
      };
    }
  };
};