/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/storage/LocalStorage.as
 * org.apache.flex.storage.LocalStorage
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.storage.LocalStorage');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.storage.IWebStorage');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @constructor
 */
org.apache.flex.storage.LocalStorage = function() {
  this.storageProvider = org.apache.flex.utils.Language.as(org.apache.flex.core.ValuesManager.valuesImpl.newInstance(this, "iStorageProvider"), org.apache.flex.storage.IWebStorage);
};


/**
 * @private
 * @type {org.apache.flex.storage.IWebStorage}
 */
org.apache.flex.storage.LocalStorage.prototype.storageProvider;


/**
 * Returns true if the platform provides local storage.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @return {boolean}
 */
org.apache.flex.storage.LocalStorage.prototype.storageAvailable = function() {
  return this.storageProvider.storageAvailable();
};


/**
 * Stores a value with a key.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @param {Object} value
 * @return {boolean}
 */
org.apache.flex.storage.LocalStorage.prototype.setItem = function(key, value) {
  var /** @type {string} */ valueAsString = org.apache.flex.utils.Language.string(value.toString());
  return this.storageProvider.setItem(key, valueAsString);
};


/**
 * Returns the value associated with the key, or undefined if there is
 * no value stored. Note that a String version of the value may have been
 * stored, depending on the platform.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @return {Object}
 */
org.apache.flex.storage.LocalStorage.prototype.getItem = function(key) {
  var /** @type {Object} */ value = this.storageProvider.getItem(key);
  return value;
};


/**
 * Removed the value and, possibly, the key from local storage. On some
 * platforms, retriving the value after removing it will be an error, on
 * others it may return undefined or null.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @return {boolean}
 */
org.apache.flex.storage.LocalStorage.prototype.removeItem = function(key) {
  return this.storageProvider.removeItem(key);
};


/**
 * Returns true if there is a value stored for the key.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 * @param {string} key
 * @return {boolean}
 */
org.apache.flex.storage.LocalStorage.prototype.hasItem = function(key) {
  return this.storageProvider.hasItem(key);
};


/**
 * Clears all values from local storage.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignoreimport window
 * @export
 */
org.apache.flex.storage.LocalStorage.prototype.clear = function() {
  this.storageProvider.clear();
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.storage.LocalStorage.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LocalStorage', qName: 'org.apache.flex.storage.LocalStorage'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.storage.LocalStorage', org.apache.flex.storage.LocalStorage);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.storage.LocalStorage.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'LocalStorage': { type: '', declaredBy: 'org.apache.flex.storage.LocalStorage'},
        'storageAvailable': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.LocalStorage'},
        'setItem': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.LocalStorage'},
        'getItem': { type: 'Object', declaredBy: 'org.apache.flex.storage.LocalStorage'},
        'removeItem': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.LocalStorage'},
        'hasItem': { type: 'Boolean', declaredBy: 'org.apache.flex.storage.LocalStorage'},
        'clear': { type: 'void', declaredBy: 'org.apache.flex.storage.LocalStorage'}
      };
    }
  };
};