/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/reflection/TypeDefinition.as
 * org.apache.flex.reflection.TypeDefinition
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.reflection.TypeDefinition');

goog.require('org.apache.flex.reflection.DefinitionWithMetaData');
goog.require('org.apache.flex.reflection.MethodDefinition');
goog.require('org.apache.flex.reflection.VariableDefinition');
goog.require('org.apache.flex.reflection.getDefinitionByName');



/**
 * @constructor
 * @extends {org.apache.flex.reflection.DefinitionWithMetaData}
 * @param {string} name
 * @param {Object=} rawData
 */
org.apache.flex.reflection.TypeDefinition = function(name, rawData) {
  rawData = typeof rawData !== 'undefined' ? rawData : null;
  var /** @type {number} */ c = name.indexOf("::");
  if (c > -1) {
    this._packageName = name.substring(0, c);
    name = name.substring(c + 2);
  }
  else
    this._packageName = "";
  org.apache.flex.reflection.TypeDefinition.base(this, 'constructor', name, rawData);
};
goog.inherits(org.apache.flex.reflection.TypeDefinition, org.apache.flex.reflection.DefinitionWithMetaData);


/**
 * @private
 * @type {string}
 */
org.apache.flex.reflection.TypeDefinition.prototype._packageName;


Object.defineProperties(org.apache.flex.reflection.TypeDefinition.prototype, /** @lends {org.apache.flex.reflection.TypeDefinition.prototype} */ {
/** @export */
packageName: {
get: /** @this {org.apache.flex.reflection.TypeDefinition} */ function() {
  return this._packageName;
}},
/** @export */
rawData: {
get: /** @this {org.apache.flex.reflection.TypeDefinition} */ function() {
  if (this._rawData == null) {
    var /** @type {Object} */ def = org.apache.flex.reflection.getDefinitionByName(this.packageName + "::" + this.name);
    
    this._rawData = def.prototype.FLEXJS_CLASS_INFO;
  }
  return this._rawData;
}},
/** @export */
baseClasses: {
get: /** @this {org.apache.flex.reflection.TypeDefinition} */ function() {
  var /** @type {Array} */ results = [];
  
  var /** @type {Object} */ data = this.rawData;
  var /** @type {string} */ name = org.apache.flex.utils.Language.string(data.names[0].qName);
  var /** @type {Object} */ def = org.apache.flex.reflection.getDefinitionByName(name);
  var /** @type {Object} */ prototype = def.prototype;
  while (prototype.FLEXJS_CLASS_INFO !== undefined) {
    name = org.apache.flex.utils.Language.string(prototype.FLEXJS_CLASS_INFO.names[0].qName);
    results.push(new org.apache.flex.reflection.TypeDefinition(name));
    def = org.apache.flex.reflection.getDefinitionByName(name);
    prototype = def.prototype;
  }
  return results;
}},
/** @export */
interfaces: {
get: /** @this {org.apache.flex.reflection.TypeDefinition} */ function() {
  var /** @type {Array} */ results = [];
  
  var /** @type {*} */ data = this.rawData;
  var /** @type {string} */ name = org.apache.flex.utils.Language.string(data.names[0].qName);
  var /** @type {Object} */ def = org.apache.flex.reflection.getDefinitionByName(name);
  var /** @type {Object} */ prototype = def.prototype;
  while (data !== undefined) {
    var /** @type {Array} */ interfaces = data.interfaces;
    if (interfaces) {
      var /** @type {number} */ n = interfaces.length;
      var foreachiter0_target = interfaces;
      for (var foreachiter0 in foreachiter0_target) 
      {
      var s = foreachiter0_target[foreachiter0];
      
        results.push(new org.apache.flex.reflection.TypeDefinition(s));}
      
    }
    name = org.apache.flex.utils.Language.string(data.names[0].qName);
    results.push(new org.apache.flex.reflection.TypeDefinition(name));
    def = org.apache.flex.reflection.getDefinitionByName(name);
    prototype = def.prototype;
    data = prototype.FLEXJS_CLASS_INFO;
  }
  return results;
}},
/** @export */
variables: {
get: /** @this {org.apache.flex.reflection.TypeDefinition} */ function() {
  var /** @type {Array} */ results = [];
  
  var /** @type {Object} */ data = this.rawData;
  var /** @type {string} */ name = org.apache.flex.utils.Language.string(data.names[0].qName);
  var /** @type {Object} */ def = org.apache.flex.reflection.getDefinitionByName(name);
  var /** @type {*} */ rdata = def.prototype.FLEXJS_REFLECTION_INFO();
  if (rdata !== undefined) {
    var /** @type {Object} */ variables = rdata.variables();
    if (variables) {
      for (var /** @type {string} */ v in variables) {
        var /** @type {Object} */ varDef = variables[v];
        results.push(new org.apache.flex.reflection.VariableDefinition(v, varDef));
      }
    }
  }
  return results;
}},
/** @export */
accessors: {
get: /** @this {org.apache.flex.reflection.TypeDefinition} */ function() {
  var /** @type {Array} */ results = [];
  
  var /** @type {Object} */ data = this.rawData;
  var /** @type {string} */ name = org.apache.flex.utils.Language.string(data.names[0].qName);
  var /** @type {Object} */ def = org.apache.flex.reflection.getDefinitionByName(name);
  var /** @type {*} */ rdata = def.prototype.FLEXJS_REFLECTION_INFO();
  if (rdata !== undefined) {
    var /** @type {Object} */ accessors = rdata.accessors();
    if (accessors) {
      for (var /** @type {string} */ prop in accessors) {
        var /** @type {Object} */ propDef = accessors[prop];
        results.push(new org.apache.flex.reflection.MethodDefinition(prop, propDef.declaredBy, propDef));
      }
    }
  }
  return results;
}},
/** @export */
methods: {
get: /** @this {org.apache.flex.reflection.TypeDefinition} */ function() {
  var /** @type {Array} */ results = [];
  
  var /** @type {Object} */ data = this.rawData;
  var /** @type {string} */ name = org.apache.flex.utils.Language.string(data.names[0].qName);
  var /** @type {Object} */ def = org.apache.flex.reflection.getDefinitionByName(name);
  var /** @type {*} */ rdata = def.prototype.FLEXJS_REFLECTION_INFO();
  if (rdata !== undefined) {
    var /** @type {Object} */ methods = rdata.methods();
    if (methods) {
      for (var /** @type {string} */ fn in methods) {
        var /** @type {Object} */ fnDef = methods[fn];
        results.push(new org.apache.flex.reflection.MethodDefinition(fn, fnDef.declaredBy, fnDef));
      }
    }
  }
  return results;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.reflection.TypeDefinition.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TypeDefinition', qName: 'org.apache.flex.reflection.TypeDefinition'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.reflection.TypeDefinition', org.apache.flex.reflection.TypeDefinition);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.reflection.TypeDefinition.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'packageName': { type: 'String', declaredBy: 'org.apache.flex.reflection.TypeDefinition'},
        'baseClasses': { type: 'Array', declaredBy: 'org.apache.flex.reflection.TypeDefinition'},
        'interfaces': { type: 'Array', declaredBy: 'org.apache.flex.reflection.TypeDefinition'},
        'variables': { type: 'Array', declaredBy: 'org.apache.flex.reflection.TypeDefinition'},
        'accessors': { type: 'Array', declaredBy: 'org.apache.flex.reflection.TypeDefinition'},
        'methods': { type: 'Array', declaredBy: 'org.apache.flex.reflection.TypeDefinition'}
      };
    },
    methods: function () {
      return {
        'TypeDefinition': { type: '', declaredBy: 'org.apache.flex.reflection.TypeDefinition'}
      };
    }
  };
};