/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/net/URLRequest.as
 * org.apache.flex.net.URLRequest
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.net.URLRequest');

goog.require('org.apache.flex.net.HTTPConstants');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @param {string=} url
 */
org.apache.flex.net.URLRequest = function(url) {
  url = typeof url !== 'undefined' ? url : null;
  
  this.method = org.apache.flex.net.HTTPConstants.GET;
  ;
  if (url != null) {
    this.url = url;
  }
  this.requestHeaders = [];
};


/**
 * @export
 * @type {string}
 */
org.apache.flex.net.URLRequest.prototype.url;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.net.URLRequest.prototype.data;


/**
 * @export
 * @type {string}
 */
org.apache.flex.net.URLRequest.prototype.contentType = "application/x-www-form-urlencoded";


/**
 * @export
 * @type {string}
 */
org.apache.flex.net.URLRequest.prototype.method;


Object.defineProperties(org.apache.flex.net.URLRequest.prototype, /** @lends {org.apache.flex.net.URLRequest.prototype} */ {
/** @export */
requestHeaders: {
get: /** @this {org.apache.flex.net.URLRequest} */ function() {
  return null;
},
set: /** @this {org.apache.flex.net.URLRequest} */ function(value) {
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.net.URLRequest.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'URLRequest', qName: 'org.apache.flex.net.URLRequest'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.net.URLRequest', org.apache.flex.net.URLRequest);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.net.URLRequest.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'url': { type: 'String'},
        'data': { type: 'Object'},
        'contentType': { type: 'String'},
        'method': { type: 'String'}
      };
    },
    accessors: function () {
      return {
        'requestHeaders': { type: 'Array', declaredBy: 'org.apache.flex.net.URLRequest'}
      };
    },
    methods: function () {
      return {
        'URLRequest': { type: '', declaredBy: 'org.apache.flex.net.URLRequest'}
      };
    }
  };
};