/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/net/HTTPService.as
 * org.apache.flex.net.HTTPService
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.net.HTTPService');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.net.HTTPConstants');
goog.require('org.apache.flex.net.HTTPHeader');
goog.require('org.apache.flex.net.HTTPServiceBase');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IStrand');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @constructor
 * @extends {org.apache.flex.net.HTTPServiceBase}
 * @implements {org.apache.flex.core.IStrand}
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.net.HTTPService = function() {
  
  this._method = org.apache.flex.net.HTTPConstants.GET;
  org.apache.flex.net.HTTPService.base(this, 'constructor');
  this.element = new XMLHttpRequest();
};
goog.inherits(org.apache.flex.net.HTTPService, org.apache.flex.net.HTTPServiceBase);


/**
 * @private
 * @type {string}
 */
org.apache.flex.net.HTTPService.prototype._contentType = "application/x-www-form-urlencoded";


/**
 * @private
 * @type {string}
 */
org.apache.flex.net.HTTPService.prototype._contentData;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.net.HTTPService.prototype._headers;


/**
 * @private
 * @type {string}
 */
org.apache.flex.net.HTTPService.prototype._method;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.net.HTTPService.prototype._responseHeaders;


/**
 * @private
 * @type {string}
 */
org.apache.flex.net.HTTPService.prototype._responseURL;


/**
 * @private
 * @type {number}
 */
org.apache.flex.net.HTTPService.prototype._status;


/**
 * @private
 * @type {string}
 */
org.apache.flex.net.HTTPService.prototype._url;


/**
 * @private
 * @type {number}
 */
org.apache.flex.net.HTTPService.prototype._timeout = 0;


/**
 * @private
 * @type {string}
 */
org.apache.flex.net.HTTPService.prototype._id;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.net.HTTPService.prototype._strand;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.net.HTTPService.prototype.beads;


/**
 *  Sends the headers and contentData to the server.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion XMLHttpRequest
 * @export
 */
org.apache.flex.net.HTTPService.prototype.send = function() {
  if (this._beads == null) {
    var foreachiter0_target = this.beads;
    for (var foreachiter0 in foreachiter0_target) 
    {
    var bead = foreachiter0_target[foreachiter0];
    
      this.addBead(bead);}
    
  }
  
  var /** @type {XMLHttpRequest} */ element = this.element;
  element.onreadystatechange = org.apache.flex.utils.Language.closure(this.progressHandler, this, 'progressHandler');
  this.url = this._url;
  var /** @type {string} */ contentData = null;
  if (this._contentData != null) {
    if (this._method === org.apache.flex.net.HTTPConstants.GET) {
      if (this.url.indexOf('?') !== -1) {
        this.url += this._contentData;
      } else {
        this.url += '?' + this._contentData;
      }
    } else {
      contentData = this._contentData;
    }
  }
  element.open(this._method, this._url, true);
  element.timeout = this._timeout;
  var /** @type {boolean} */ sawContentType = false;
  if (this._headers) {
    var /** @type {number} */ n = this._headers.length;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {org.apache.flex.net.HTTPHeader} */ header = this._headers[i];
      if (header.name === org.apache.flex.net.HTTPHeader.CONTENT_TYPE) {
        sawContentType = true;
      }
      element.setRequestHeader(header.name, header.value);
    }
  }
  if (this._method !== org.apache.flex.net.HTTPConstants.GET && !sawContentType && contentData) {
    element.setRequestHeader(org.apache.flex.net.HTTPHeader.CONTENT_TYPE, this._contentType);
  }
  if (contentData) {
    element.setRequestHeader('Content-length', contentData.length.toString());
    element.setRequestHeader('Connection', 'close');
    element.send(contentData);
  } else {
    element.send();
  }
};


/**
 * @flexjsignorecoercion XMLHttpRequest
 * @protected
 */
org.apache.flex.net.HTTPService.prototype.progressHandler = function() {
  var /** @type {XMLHttpRequest} */ element = this.element;
  if (element.readyState === 2) {
    this._status = element.status;
    this.dispatchEvent('httpResponseStatus');
    this.dispatchEvent('httpStatus');
  } else if (element.readyState === 4) {
    this.dispatchEvent('complete');
  }
};


/**
 * @private
 * @type {Object}
 */
org.apache.flex.net.HTTPService.prototype._json;


Object.defineProperties(org.apache.flex.net.HTTPService.prototype, /** @lends {org.apache.flex.net.HTTPService.prototype} */ {
/** @export */
contentType: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._contentType;
},
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  if (this._contentType != value) {
    this._contentType = value;
    this.dispatchEvent(new org.apache.flex.events.Event("contentTypeChanged"));
  }
}},
/** @export */
contentData: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._contentData;
},
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  if (this._contentData != value) {
    this._contentData = value;
    this.dispatchEvent(new org.apache.flex.events.Event("contentDataChanged"));
  }
}},
/** @export */
headers: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  if (this._headers == null)
    this._headers = [];
  return this._headers;
},
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  if (this._headers != value) {
    this._headers = value;
    this.dispatchEvent(new org.apache.flex.events.Event("headersChanged"));
  }
}},
/** @export */
method: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._method;
},
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  if (this._method != value) {
    this._method = value;
    this.dispatchEvent(new org.apache.flex.events.Event("methodChanged"));
  }
}},
/** @export */
responseHeaders: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  
  var /** @type {string} */ allHeaders;
  var /** @type {number} */ c;
  var /** @type {string} */ hdr;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  var /** @type {string} */ part1;
  var /** @type {string} */ part2;
  var /** @type {XMLHttpRequest} */ element = this.element;
  if (typeof(this._responseHeaders) === 'undefined') {
    allHeaders = element.getAllResponseHeaders();
    this._responseHeaders = allHeaders.split('\n');
    n = this._responseHeaders.length;
    for (i = 0; i < n; i++) {
      hdr = org.apache.flex.utils.Language.string(this._responseHeaders[i]);
      c = hdr.indexOf(':');
      part1 = hdr.substring(0, c);
      part2 = hdr.substring(c + 2);
      this._responseHeaders[i] = new org.apache.flex.net.HTTPHeader(part1, part2);
    }
  }
  return this._responseHeaders;
}},
/** @export */
responseURL: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._responseURL;
}},
/** @export */
status: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._status;
}},
/** @export */
url: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._url;
},
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  if (this._url != value) {
    this._url = value;
    this.dispatchEvent(new org.apache.flex.events.Event("urlChanged"));
  }
}},
/** @export */
timeout: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._timeout;
},
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  if (this._timeout != value) {
    this._timeout = value;
    this.dispatchEvent(new org.apache.flex.events.Event("timeoutChanged"));
  }
}},
/** @export */
id: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  return this._id;
},
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  if (this._id != value) {
    this._id = value;
    this.dispatchEvent(new org.apache.flex.events.Event("idChanged"));
  }
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.net.HTTPService} */ function(value) {
  this._strand = value;
  if (this._beads == null) {
    var foreachiter1_target = this.beads;
    for (var foreachiter1 in foreachiter1_target) 
    {
    var bead = foreachiter1_target[foreachiter1];
    
      this.addBead(bead);}
    
  }
  this.dispatchEvent(new org.apache.flex.events.Event("beadsAdded"));
}},
/** @export */
data: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  
  return this.element.responseText;
}},
/** @export */
json: {
get: /** @this {org.apache.flex.net.HTTPService} */ function() {
  if (!this._json)
    this._json = JSON.parse(this.data);
  return this._json;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.net.HTTPService.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'HTTPService', qName: 'org.apache.flex.net.HTTPService'}], interfaces: [org.apache.flex.core.IStrand, org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.net.HTTPService', org.apache.flex.net.HTTPService);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.net.HTTPService.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'beads': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'contentType': { type: 'String', declaredBy: 'org.apache.flex.net.HTTPService'},
        'contentData': { type: 'String', declaredBy: 'org.apache.flex.net.HTTPService'},
        'headers': { type: 'Array', declaredBy: 'org.apache.flex.net.HTTPService'},
        'method': { type: 'String', declaredBy: 'org.apache.flex.net.HTTPService'},
        'responseHeaders': { type: 'Array', declaredBy: 'org.apache.flex.net.HTTPService'},
        'responseURL': { type: 'String', declaredBy: 'org.apache.flex.net.HTTPService'},
        'status': { type: 'int', declaredBy: 'org.apache.flex.net.HTTPService'},
        'url': { type: 'String', declaredBy: 'org.apache.flex.net.HTTPService'},
        'timeout': { type: 'Number', declaredBy: 'org.apache.flex.net.HTTPService'},
        'id': { type: 'String', declaredBy: 'org.apache.flex.net.HTTPService'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.net.HTTPService'},
        'data': { type: 'String', declaredBy: 'org.apache.flex.net.HTTPService'},
        'json': { type: 'Object', declaredBy: 'org.apache.flex.net.HTTPService'}
      };
    },
    methods: function () {
      return {
        'HTTPService': { type: '', declaredBy: 'org.apache.flex.net.HTTPService'},
        'send': { type: 'void', declaredBy: 'org.apache.flex.net.HTTPService'}
      };
    },
    metadata: function () { return [ ]; }
  };
};