/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/beads/ViewManagerViewBase.as
 * org.apache.flex.mobile.beads.ViewManagerViewBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.beads.ViewManagerViewBase');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.layouts.HorizontalLayout');
goog.require('org.apache.flex.mobile.chrome.NavigationBar');
goog.require('org.apache.flex.mobile.models.ViewManagerModel');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.mobile.IViewManagerView');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.mobile.beads.ViewManagerViewBase = function() {
  ;
};


/**
 * @private
 * @type {org.apache.flex.mobile.chrome.NavigationBar}
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype._navigationBar;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype._strand;


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype.viewsChangedHandler = function(event) {
  this.layoutChromeElements();
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype.sizeChangedHandler = function(event) {
  this.layoutChromeElements();
};


/**
 * @asprivate
 * @protected
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype.layoutChromeElements = function() {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {number} */ contentAreaY = 0;
  var /** @type {number} */ contentAreaHeight = host.height;
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  if (this._navigationBar) {
    this._navigationBar.x = 0;
    this._navigationBar.y = 0;
    this._navigationBar.width = host.width;
    contentAreaHeight -= this._navigationBar.height;
    contentAreaY = this._navigationBar.height;
    model.navigationBar = this._navigationBar;
  }
  model.contentX = 0;
  model.contentY = contentAreaY;
  model.contentWidth = host.width;
  model.contentHeight = contentAreaHeight;
  this.sizeViewsToFitContentArea();
};


/**
 * @protected
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype.sizeViewsToFitContentArea = function() {
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  var /** @type {number} */ n = org.apache.flex.utils.Language.as(model, org.apache.flex.mobile.models.ViewManagerModel, true).views.length;
  if (n > 0) {
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {org.apache.flex.mobile.IViewManagerView} */ view = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(model, org.apache.flex.mobile.models.ViewManagerModel, true).views[i], org.apache.flex.mobile.IViewManagerView);
      org.apache.flex.utils.Language.as(view, org.apache.flex.core.UIBase, true).x = model.contentX;
      org.apache.flex.utils.Language.as(view, org.apache.flex.core.UIBase, true).y = model.contentY;
      org.apache.flex.utils.Language.as(view, org.apache.flex.core.UIBase, true).setWidthAndHeight(model.contentWidth, model.contentHeight, true);
    }
  }
};


Object.defineProperties(org.apache.flex.mobile.beads.ViewManagerViewBase.prototype, /** @lends {org.apache.flex.mobile.beads.ViewManagerViewBase.prototype} */ {
/** @export */
host: {
get: /** @this {org.apache.flex.mobile.beads.ViewManagerViewBase} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
},
set: /** @this {org.apache.flex.mobile.beads.ViewManagerViewBase} */ function(value) {
}},
/** @export */
navigationBar: {
get: /** @this {org.apache.flex.mobile.beads.ViewManagerViewBase} */ function() {
  return this._navigationBar;
},
set: /** @this {org.apache.flex.mobile.beads.ViewManagerViewBase} */ function(value) {
}},
/** @export */
strand: {
get: /** @this {org.apache.flex.mobile.beads.ViewManagerViewBase} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.mobile.beads.ViewManagerViewBase} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.sizeChangedHandler, this, 'sizeChangedHandler'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.sizeChangedHandler, this, 'sizeChangedHandler'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.sizeChangedHandler, this, 'sizeChangedHandler'));
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  model.addEventListener("selectedIndexChanged", org.apache.flex.utils.Language.closure(this.viewsChangedHandler, this, 'viewsChangedHandler'));
  if (model.navigationBarItems) {
    this._navigationBar = new org.apache.flex.mobile.chrome.NavigationBar();
    this._navigationBar.controls = model.navigationBarItems;
    this._navigationBar.addBead(new org.apache.flex.html.beads.layouts.HorizontalLayout());
    org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this._navigationBar, false);
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ViewManagerViewBase', qName: 'org.apache.flex.mobile.beads.ViewManagerViewBase'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.beads.ViewManagerViewBase', org.apache.flex.mobile.beads.ViewManagerViewBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.beads.ViewManagerViewBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'host': { type: 'IUIBase', declaredBy: 'org.apache.flex.mobile.beads.ViewManagerViewBase'},
        'navigationBar': { type: 'NavigationBar', declaredBy: 'org.apache.flex.mobile.beads.ViewManagerViewBase'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.mobile.beads.ViewManagerViewBase'}
      };
    },
    methods: function () {
      return {
        'ViewManagerViewBase': { type: '', declaredBy: 'org.apache.flex.mobile.beads.ViewManagerViewBase'}
      };
    }
  };
};