/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/ManagerBase.as
 * org.apache.flex.mobile.ManagerBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.ManagerBase');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.IChrome');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.mobile.ManagerBase = function() {
  org.apache.flex.mobile.ManagerBase.base(this, 'constructor');
  this._contentArea = new org.apache.flex.core.UIBase();
  
  this.createElement();
  org.apache.flex.mobile.ManagerBase.base(this, 'constructor', this._contentArea, false);
};
goog.inherits(org.apache.flex.mobile.ManagerBase, org.apache.flex.core.UIBase);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.mobile.ManagerBase.prototype.createElement = function() {
  org.apache.flex.mobile.ManagerBase.base(this, 'createElement');
  this.element.className = 'ManagerBase';
  this._contentArea.positioner.style['width'] = '100%';
  this._contentArea.positioner.style['height'] = '100%';
  return this.element;
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.ManagerBase.prototype.handleInitComplete = function(event) {
  this._contentArea.setWidthAndHeight(this.width, this.height, true);
  var /** @type {number} */ num = org.apache.flex.utils.Language.as(this._contentArea, org.apache.flex.core.UIBase, true).numElements;
  for (var /** @type {number} */ i = 0; i < num; i++) {
    var /** @type {org.apache.flex.core.UIBase} */ child = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._contentArea, org.apache.flex.core.UIBase, true).getElementAt(i), org.apache.flex.core.UIBase);
    child.setWidthAndHeight(this.width, this.height);
  }
};


/**
 * @private
 * @type {org.apache.flex.core.UIBase}
 */
org.apache.flex.mobile.ManagerBase.prototype._contentArea;


/**
 * Adds elements to the view manager. If an element implements IChrome it is placed
 * in the chrome area otherwise it is placed in the contentArea.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.mobile.ManagerBase.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  if (org.apache.flex.utils.Language.is(c, org.apache.flex.core.IChrome)) {
    org.apache.flex.mobile.ManagerBase.base(this, 'addElementAt', c, 0, dispatchEvent);
  } else {
    this._contentArea.addElement(c, dispatchEvent);
  }
};


/**
 * @asprivate.
 * @export
 * @override
 */
org.apache.flex.mobile.ManagerBase.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  if (org.apache.flex.utils.Language.is(c, org.apache.flex.core.IChrome)) {
    org.apache.flex.mobile.ManagerBase.base(this, 'addElementAt', c, index, dispatchEvent);
  } else {
    this._contentArea.addElement(c, dispatchEvent);
  }
};


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.mobile.ManagerBase.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  if (org.apache.flex.utils.Language.is(c, org.apache.flex.core.IChrome)) {
    org.apache.flex.mobile.ManagerBase.base(this, 'removeElement', c, dispatchEvent);
  } else {
    this._contentArea.removeElement(c, dispatchEvent);
  }
};


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.mobile.ManagerBase.prototype.getElementAt = function(index) {
  return this._contentArea.getElementAt(index);
};


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.mobile.ManagerBase.prototype.getElementIndex = function(c) {
  return this._contentArea.getElementIndex(c);
};


Object.defineProperties(org.apache.flex.mobile.ManagerBase.prototype, /** @lends {org.apache.flex.mobile.ManagerBase.prototype} */ {
/** @export */
contentArea: {
get: /** @this {org.apache.flex.mobile.ManagerBase} */ function() {
  return this._contentArea;
}},
/** @export */
numElements: {
get: /** @this {org.apache.flex.mobile.ManagerBase} */ function() {
  return this._contentArea.numElements;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.ManagerBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ManagerBase', qName: 'org.apache.flex.mobile.ManagerBase'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.ManagerBase', org.apache.flex.mobile.ManagerBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.ManagerBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'contentArea': { type: 'UIBase', declaredBy: 'org.apache.flex.mobile.ManagerBase'},
        'numElements': { type: 'int', declaredBy: 'org.apache.flex.mobile.ManagerBase'}
      };
    },
    methods: function () {
      return {
        'ManagerBase': { type: '', declaredBy: 'org.apache.flex.mobile.ManagerBase'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.mobile.ManagerBase'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.mobile.ManagerBase'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.mobile.ManagerBase'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.mobile.ManagerBase'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.mobile.ManagerBase'}
      };
    }
  };
};