/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/DatePicker.as
 * org.apache.flex.mobile.DatePicker
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.DatePicker');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IDateChooserModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.mobile.DatePicker = function() {
  org.apache.flex.mobile.DatePicker.base(this, 'constructor');
  this.className = "DatePicker";
  this.setWidthAndHeight(120, 60, true);
  this.selectedDate = new Date();
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.events.IEventDispatcher, true).addEventListener("selectedDateChanged", org.apache.flex.utils.Language.closure(this.handleDateChange, this, 'handleDateChange'));
};
goog.inherits(org.apache.flex.mobile.DatePicker, org.apache.flex.core.UIBase);


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.DatePicker.prototype.handleDateChange = function(event) {
  this.dispatchEvent(new org.apache.flex.events.Event("selectedDateChanged"));
};


Object.defineProperties(org.apache.flex.mobile.DatePicker.prototype, /** @lends {org.apache.flex.mobile.DatePicker.prototype} */ {
/** @export */
selectedDate: {
get: /** @this {org.apache.flex.mobile.DatePicker} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDateChooserModel, true).selectedDate;
},
set: /** @this {org.apache.flex.mobile.DatePicker} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDateChooserModel, true).selectedDate = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.DatePicker.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DatePicker', qName: 'org.apache.flex.mobile.DatePicker'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.DatePicker', org.apache.flex.mobile.DatePicker);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.DatePicker.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'selectedDate': { type: 'Date', declaredBy: 'org.apache.flex.mobile.DatePicker'}
      };
    },
    methods: function () {
      return {
        'DatePicker': { type: '', declaredBy: 'org.apache.flex.mobile.DatePicker'}
      };
    },
    metadata: function () { return [ ]; }
  };
};