/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/cordova/Application.as
 * org.apache.cordova.Application
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.cordova.Application');

goog.require('org.apache.flex.core.Application');
goog.require('org.apache.flex.core.IFlexInfo');
goog.require('org.apache.flex.utils.Language');



/**
 * FalconJX will inject html into the index.html file.  Surround with
 * "inject_html" tag as follows:
 *
 * <inject_html>
 * <script type="text/javascript" src="cordova.js"></script>
 * </inject_html>
 * @constructor
 * @extends {org.apache.flex.core.Application}
 * @implements {org.apache.flex.core.IFlexInfo}
 */
org.apache.cordova.Application = function() {
  org.apache.cordova.Application.base(this, 'constructor');
};
goog.inherits(org.apache.cordova.Application, org.apache.flex.core.Application);


/**
 * @export
 * @type {boolean}
 */
org.apache.cordova.Application.prototype.isDeviceReady = false;


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.cordova.Application.prototype.start = function() {
  document.addEventListener("deviceReady", org.apache.flex.utils.Language.closure(this.startOnReady, this, 'startOnReady'), false);
  this.addEventListener("preinitialize", org.apache.flex.utils.Language.closure(this.handlePreInit, this, 'handlePreInit'));
  org.apache.cordova.Application.base(this, 'start');
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.cordova.Application.prototype.handlePreInit = function(event) {
  if (!this.isDeviceReady) {
    event.preventDefault();
  }
};


/**
 * @asprivate
 * @private
 * @param {*} event
 */
org.apache.cordova.Application.prototype.startOnReady = function(event) {
  this.isDeviceReady = true;
  this.removeEventListener("preinitialize", org.apache.flex.utils.Language.closure(this.handlePreInit, this, 'handlePreInit'));
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.cordova.Application.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Application', qName: 'org.apache.cordova.Application'}], interfaces: [org.apache.flex.core.IFlexInfo] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.cordova.Application', org.apache.cordova.Application);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.cordova.Application.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'isDeviceReady': { type: 'Boolean'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Application': { type: '', declaredBy: 'org.apache.cordova.Application'},
        'start': { type: 'void', declaredBy: 'org.apache.cordova.Application'}
      };
    }
  };
};