/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/VerticalLayout.as
 * org.apache.flex.html.beads.layouts.VerticalLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.VerticalLayout');

goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.html.beads.layouts.VerticalLayout = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.VerticalLayout.prototype.host;


/**
 *  Layout children vertically
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.ILayoutHost
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.VerticalLayout.prototype.layout = function() {
  
  var /** @type {Array} */ children;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  var /** @type {Object} */ viewBead = this.host.getBeadByType(org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = viewBead.contentView;
  children = contentView.internalChildren();
  var /** @type {Object} */ scv = getComputedStyle(this.host.positioner);
  var /** @type {boolean} */ hasWidth = !this.host.isWidthSizedToContent();
  var /** @type {number} */ maxWidth = 0;
  n = children.length;
  for (i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.WrappedHTMLElement} */ child = children[i];
    child.flexjs_wrapper.setDisplayStyleForLayout('block');
    if (child.style.display === 'none') {
      child.flexjs_wrapper.setDisplayStyleForLayout('block');
    } else {
      child.style.display = 'inline-block';
      maxWidth = Math.max(maxWidth, child.offsetLeft + child.offsetWidth);
      child.style.display = 'block';
    }
    child.flexjs_wrapper.dispatchEvent('sizeChanged');
  }
  if (!hasWidth && n > 0 && !isNaN(maxWidth)) {
    var /** @type {string} */ pl = org.apache.flex.utils.Language.string(scv['padding-left']);
    var /** @type {string} */ pr = org.apache.flex.utils.Language.string(scv['padding-right']);
    var /** @type {number} */ npl = parseInt(pl.substring(0, pl.length - 2), 10);
    var /** @type {number} */ npr = parseInt(pr.substring(0, pr.length - 2), 10);
    maxWidth += npl + npr;
    contentView.width = maxWidth;
  }
  return true;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.VerticalLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.VerticalLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.VerticalLayout} */ function(value) {
  this.host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.ILayoutChild);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.VerticalLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'VerticalLayout', qName: 'org.apache.flex.html.beads.layouts.VerticalLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.VerticalLayout', org.apache.flex.html.beads.layouts.VerticalLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.VerticalLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.VerticalLayout'}
      };
    },
    methods: function () {
      return {
        'VerticalLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.VerticalLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.VerticalLayout'}
      };
    }
  };
};