/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/HorizontalLayout.as
 * org.apache.flex.html.beads.layouts.HorizontalLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.HorizontalLayout');

goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.html.beads.layouts.HorizontalLayout = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.HorizontalLayout.prototype.host;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @flexjsignorecoercion org.apache.flex.core.ILayoutHost
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.HorizontalLayout.prototype.layout = function() {
  
  var /** @type {Array} */ children;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  var /** @type {Object} */ viewBead = this.host.getBeadByType(org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = viewBead.contentView;
  children = contentView.internalChildren();
  var /** @type {boolean} */ hasHeight = !this.host.isHeightSizedToContent();
  var /** @type {boolean} */ hasWidth = !this.host.isWidthSizedToContent();
  var /** @type {number} */ maxHeight = 0;
  var /** @type {number} */ computedWidth = 0;
  n = children.length;
  for (i = 0; i < n; i++) {
    var /** @type {Object} */ child = children[i];
    child.flexjs_wrapper.internalDisplay = 'inline-block';
    if (child.style.display == 'none')
      child.flexjs_wrapper.setDisplayStyleForLayout('inline-block');
    else
      child.style.display = 'inline-block';
    maxHeight = Math.max(maxHeight, child.offsetHeight);
    if (!hasWidth) {
      var /** @type {Object} */ cv = getComputedStyle(child);
      var /** @type {string} */ mls = org.apache.flex.utils.Language.string(cv['margin-left']);
      var /** @type {number} */ ml = Number(mls.substring(0, mls.length - 2));
      var /** @type {string} */ mrs = org.apache.flex.utils.Language.string(cv['margin-right']);
      var /** @type {number} */ mr = Number(mrs.substring(0, mrs.length - 2));
      computedWidth += ml + child.offsetWidth + mr;
    }
    child.flexjs_wrapper.dispatchEvent('sizeChanged');
  }
  if (!hasHeight && n > 0 && !isNaN(maxHeight)) {
    contentView.height = maxHeight;
  }
  if (!hasWidth && n > 0 && !isNaN(computedWidth)) {
    contentView.width = computedWidth + 1;
  }
  return true;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.HorizontalLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.HorizontalLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.HorizontalLayout} */ function(value) {
  this.host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.ILayoutChild);
  org.apache.flex.utils.Language.as(value, org.apache.flex.core.IUIBase).element.style.display = 'block';
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.HorizontalLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'HorizontalLayout', qName: 'org.apache.flex.html.beads.layouts.HorizontalLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.HorizontalLayout', org.apache.flex.html.beads.layouts.HorizontalLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.HorizontalLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.HorizontalLayout'}
      };
    },
    methods: function () {
      return {
        'HorizontalLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.HorizontalLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.HorizontalLayout'}
      };
    }
  };
};