/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/ButtonBarLayout.as
 * org.apache.flex.html.beads.layouts.ButtonBarLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.ButtonBarLayout');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.beads.ButtonBarView');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.IItemRendererParent');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.html.beads.layouts.ButtonBarLayout = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.layouts.ButtonBarLayout.prototype._strand;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.beads.layouts.ButtonBarLayout.prototype._buttonWidths = null;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.ButtonBarLayout.prototype.layout = function() {
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = org.apache.flex.utils.Language.as(layoutParent.contentView, org.apache.flex.core.IParentIUIBase);
  var /** @type {org.apache.flex.core.IItemRendererParent} */ itemRendererParent = org.apache.flex.utils.Language.as(contentView, org.apache.flex.core.IItemRendererParent);
  var /** @type {org.apache.flex.core.IViewportModel} */ viewportModel = org.apache.flex.utils.Language.as(layoutParent, org.apache.flex.html.beads.ButtonBarView).viewportModel;
  var /** @type {number} */ n = contentView.numElements;
  var /** @type {number} */ realN = n;
  for (var /** @type {number} */ j = 0; j < n; j++) {
    var /** @type {org.apache.flex.core.IUIBase} */ child = org.apache.flex.utils.Language.as(itemRendererParent.getElementAt(j), org.apache.flex.core.IUIBase);
    if (child == null || !child.visible)
      realN--;
  }
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ useWidth = contentView.width / realN;
  var /** @type {number} */ useHeight = contentView.height;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ ir = org.apache.flex.utils.Language.as(itemRendererParent.getElementAt(i), org.apache.flex.core.ISelectableItemRenderer);
    if (ir == null || !org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).visible)
      continue;
    org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).y = 0;
    org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).x = xpos;
    if (!isNaN(useHeight) && useHeight > 0) {
      org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).height = useHeight;
    }
    if (this.buttonWidths)
      org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).width = Number(this.buttonWidths[i]); else if (!isNaN(useWidth) && useWidth > 0) {
      org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).width = useWidth;
    }
    xpos += org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).width;
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("layoutComplete"));
  return true;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.ButtonBarLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.ButtonBarLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.ButtonBarLayout} */ function(value) {
  this._strand = value;
}},
/** @export */
buttonWidths: {
get: /** @this {org.apache.flex.html.beads.layouts.ButtonBarLayout} */ function() {
  return this._buttonWidths;
},
set: /** @this {org.apache.flex.html.beads.layouts.ButtonBarLayout} */ function(value) {
  this._buttonWidths = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.ButtonBarLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ButtonBarLayout', qName: 'org.apache.flex.html.beads.layouts.ButtonBarLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.ButtonBarLayout', org.apache.flex.html.beads.layouts.ButtonBarLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.ButtonBarLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.ButtonBarLayout'},
        'buttonWidths': { type: 'Array', declaredBy: 'org.apache.flex.html.beads.layouts.ButtonBarLayout'}
      };
    },
    methods: function () {
      return {
        'ButtonBarLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.ButtonBarLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.ButtonBarLayout'}
      };
    }
  };
};