/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/TextItemRendererFactoryForArrayData.as
 * org.apache.flex.html.beads.TextItemRendererFactoryForArrayData
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.TextItemRendererFactoryForArrayData');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDataProviderItemRendererMapper');
goog.require('org.apache.flex.core.IItemRendererClassFactory');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.html.beads.ITextItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDataProviderItemRendererMapper}
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.ISelectionModel}
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype.selectionModel;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype._strand;


/**
 * @private
 * @type {org.apache.flex.core.IItemRendererClassFactory}
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype._itemRendererFactory;


/**
 * @protected
 * @type {org.apache.flex.core.IItemRendererParent}
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype.dataGroup;


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype.dataProviderChangeHandler = function(event) {
  var /** @type {Array} */ dp = org.apache.flex.utils.Language.as(this.selectionModel.dataProvider, Array);
  if (!dp)
    return;
  this.dataGroup.removeAllElements();
  var /** @type {number} */ n = dp.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.html.beads.ITextItemRenderer} */ tf = org.apache.flex.utils.Language.as(this.itemRendererFactory.createItemRenderer(this.dataGroup), org.apache.flex.html.beads.ITextItemRenderer);
    tf.index = i;
    this.dataGroup.addElement(tf);
    if (this.selectionModel.labelField)
      tf.text = org.apache.flex.utils.Language.string(dp[i][this.selectionModel.labelField]);
    else
      tf.text = org.apache.flex.utils.Language.string(dp[i]);
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("itemsCreated"));
};


Object.defineProperties(org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype, /** @lends {org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.TextItemRendererFactoryForArrayData} */ function(value) {
  this._strand = value;
  this.selectionModel = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {org.apache.flex.html.beads.IListView} */ listView = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  this.dataGroup = listView.dataGroup;
  this.selectionModel.addEventListener("dataProviderChanged", org.apache.flex.utils.Language.closure(this.dataProviderChangeHandler, this, 'dataProviderChangeHandler'));
  if (!this.itemRendererFactory) {
    this._itemRendererFactory = org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this._strand, "iItemRendererClassFactory"))(), org.apache.flex.core.IItemRendererClassFactory);
    this._strand.addBead(this._itemRendererFactory);
  }
  this.dataProviderChangeHandler(null);
}},
/** @export */
itemRendererFactory: {
get: /** @this {org.apache.flex.html.beads.TextItemRendererFactoryForArrayData} */ function() {
  return this._itemRendererFactory;
},
set: /** @this {org.apache.flex.html.beads.TextItemRendererFactoryForArrayData} */ function(value) {
  this._itemRendererFactory = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TextItemRendererFactoryForArrayData', qName: 'org.apache.flex.html.beads.TextItemRendererFactoryForArrayData'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDataProviderItemRendererMapper] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.TextItemRendererFactoryForArrayData', org.apache.flex.html.beads.TextItemRendererFactoryForArrayData);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.TextItemRendererFactoryForArrayData.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.TextItemRendererFactoryForArrayData'},
        'itemRendererFactory': { type: 'IItemRendererClassFactory', declaredBy: 'org.apache.flex.html.beads.TextItemRendererFactoryForArrayData'}
      };
    },
    methods: function () {
      return {
        'TextItemRendererFactoryForArrayData': { type: '', declaredBy: 'org.apache.flex.html.beads.TextItemRendererFactoryForArrayData'}
      };
    }
  };
};