/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/TransformBead.as
 * org.apache.flex.svg.TransformBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.TransformBead');

goog.require('org.apache.flex.core.TransformModel');
goog.require('org.apache.flex.core.IBeadTransform');
goog.require('org.apache.flex.core.ITransformHost');
goog.require('org.apache.flex.core.ITransformModel');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.core.IBeadTransform}
 */
org.apache.flex.svg.TransformBead = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.svg.TransformBead.prototype._strand;


/**
 * @flexjsignorecoercion HTMLElement
 * @export
 */
org.apache.flex.svg.TransformBead.prototype.transform = function() {
  var /** @type {org.apache.flex.core.WrappedHTMLElement} */ element = this.host.transformElement;
  element.parentNode.setAttribute("overflow", "visible");
  var /** @type {org.apache.flex.geom.Matrix} */ fjsm = this.transformModel.matrix;
  var /** @type {Array} */ matrixArray = [fjsm.a, fjsm.b, fjsm.c, fjsm.d, fjsm.tx, fjsm.ty];
  var /** @type {string} */ transformStr = "matrix(" + matrixArray.join(",") + ")";
  element.setAttribute("transform", transformStr);
};


/**
 * @private
 * @param {org.apache.flex.events.Event} e
 */
org.apache.flex.svg.TransformBead.prototype.changeHandler = function(e) {
  this.transform();
};


Object.defineProperties(org.apache.flex.svg.TransformBead.prototype, /** @lends {org.apache.flex.svg.TransformBead.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.svg.TransformBead} */ function(value) {
  this._strand = value;
  this.host.addEventListener(org.apache.flex.core.TransformModel.CHANGE, org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
  var /** @type {org.apache.flex.core.ITransformModel} */ model = this.transformModel;
  if (model && model.matrix) {
    this.transform();
  }
}},
/** @export */
transformModel: {
get: /** @this {org.apache.flex.svg.TransformBead} */ function() {
  return org.apache.flex.utils.Language.as(this.host.getBeadByType(org.apache.flex.core.ITransformModel), org.apache.flex.core.ITransformModel);
}},
/** @export */
host: {
get: /** @this {org.apache.flex.svg.TransformBead} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.ITransformHost);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.TransformBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TransformBead', qName: 'org.apache.flex.svg.TransformBead'}], interfaces: [org.apache.flex.core.IBeadTransform] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.TransformBead', org.apache.flex.svg.TransformBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.TransformBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.svg.TransformBead'},
        'transformModel': { type: 'ITransformModel', declaredBy: 'org.apache.flex.svg.TransformBead'},
        'host': { type: 'ITransformHost', declaredBy: 'org.apache.flex.svg.TransformBead'}
      };
    },
    methods: function () {
      return {
        'TransformBead': { type: '', declaredBy: 'org.apache.flex.svg.TransformBead'},
        'transform': { type: 'void', declaredBy: 'org.apache.flex.svg.TransformBead'}
      };
    }
  };
};