/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/GraphicContainer.as
 * org.apache.flex.svg.GraphicContainer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.GraphicContainer');

goog.require('org.apache.flex.core.ContainerBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.WrappedHTMLElement');
goog.require('org.apache.flex.core.IContainer');
goog.require('org.apache.flex.core.ITransformHost');



/**
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 * @implements {org.apache.flex.core.ITransformHost}
 * @implements {org.apache.flex.core.IContainer}
 */
org.apache.flex.svg.GraphicContainer = function() {
  org.apache.flex.svg.GraphicContainer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.svg.GraphicContainer, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {org.apache.flex.core.ContainerBase}
 */
org.apache.flex.svg.GraphicContainer.prototype.graphicGroup;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.svg.GraphicContainer.prototype.createElement = function() {
  this.element = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  this.graphicGroup = new org.apache.flex.svg.GraphicContainer.GraphicGroup();
  org.apache.flex.svg.GraphicContainer.base(this, 'addElement', this.graphicGroup);
  return this.element;
};


/**
 *  @copy org.apache.flex.core.IParent#getElementAt()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.svg.GraphicContainer.prototype.getElementAt = function(index) {
  return this.graphicGroup.getElementAt(index);
};


/**
 *  @copy org.apache.flex.core.IParent#addElement()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.svg.GraphicContainer.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.graphicGroup.addElement(c, dispatchEvent);
  if (dispatchEvent)
    this.dispatchEvent(new Event("childrenAdded"));
};


/**
 *  @copy org.apache.flex.core.IParent#addElementAt()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.svg.GraphicContainer.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.graphicGroup.addElementAt(c, index, dispatchEvent);
  if (dispatchEvent)
    this.dispatchEvent(new Event("childrenAdded"));
};


/**
 *  @copy org.apache.flex.core.IParent#removeElement()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.svg.GraphicContainer.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.graphicGroup.removeElement(c, dispatchEvent);
  if (dispatchEvent)
    this.dispatchEvent(new Event("childrenRemoved"));
};


/**
 *  @copy org.apache.flex.core.IContainer#childrenAdded()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.svg.GraphicContainer.prototype.childrenAdded = function() {
  this.dispatchEvent(new Event("childrenAdded"));
};


/**
 *  @copy org.apache.flex.core.IParent#getElementIndex()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.svg.GraphicContainer.prototype.getElementIndex = function(c) {
  return this.graphicGroup.getElementIndex(c);
};


Object.defineProperties(org.apache.flex.svg.GraphicContainer.prototype, /** @lends {org.apache.flex.svg.GraphicContainer.prototype} */ {
/** @export */
transformElement: {
get: /** @this {org.apache.flex.svg.GraphicContainer} */ function() {
  return this.graphicGroup.element;
}},
/** @export */
numElements: {
get: /** @this {org.apache.flex.svg.GraphicContainer} */ function() {
  return this.graphicGroup.numElements;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.GraphicContainer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GraphicContainer', qName: 'org.apache.flex.svg.GraphicContainer'}], interfaces: [org.apache.flex.core.ITransformHost, org.apache.flex.core.IContainer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.GraphicContainer', org.apache.flex.svg.GraphicContainer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.GraphicContainer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'transformElement': { type: 'org.apache.flex.core.WrappedHTMLElement', declaredBy: 'org.apache.flex.svg.GraphicContainer'},
        'numElements': { type: 'int', declaredBy: 'org.apache.flex.svg.GraphicContainer'}
      };
    },
    methods: function () {
      return {
        'GraphicContainer': { type: '', declaredBy: 'org.apache.flex.svg.GraphicContainer'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.svg.GraphicContainer'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.svg.GraphicContainer'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.svg.GraphicContainer'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.svg.GraphicContainer'},
        'childrenAdded': { type: 'void', declaredBy: 'org.apache.flex.svg.GraphicContainer'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.svg.GraphicContainer'}
      };
    }
  };
};



/**
 * @constructor
 * @extends {org.apache.flex.core.ContainerBase}
 */
org.apache.flex.svg.GraphicContainer.GraphicGroup = function() {
  org.apache.flex.svg.GraphicContainer.GraphicGroup.base(this, 'constructor');
};
goog.inherits(org.apache.flex.svg.GraphicContainer.GraphicGroup, org.apache.flex.core.ContainerBase);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.svg.GraphicContainer.GraphicGroup.prototype.createElement = function() {
  this.element = document.createElementNS('http://www.w3.org/2000/svg', 'g');
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  return this.element;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.GraphicContainer.GraphicGroup.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GraphicGroup', qName: 'org.apache.flex.svg.GraphicContainer.GraphicGroup'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.GraphicContainer.GraphicGroup', org.apache.flex.svg.GraphicContainer.GraphicGroup);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.GraphicContainer.GraphicGroup.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
      };
    }
  };
};