/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/SolidColor.as
 * org.apache.flex.graphics.SolidColor
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.SolidColor');

goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.graphics.IFill');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @asparam color Specifies the color.
 *  The default value is 0x000000 (black).
 *
 *  @asparam alpha Specifies the level of transparency.
 *  Valid values range from 0.0 (completely transparent)
 *  to 1.0 (completely opaque).
 *  The default value is 1.0.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @implements {org.apache.flex.graphics.IFill}
 * @param {number=} color
 * @param {number=} alpha
 */
org.apache.flex.graphics.SolidColor = function(color, alpha) {
  color = typeof color !== 'undefined' ? color : 0x000000;
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  ;
  this.color = color;
  this.alpha = alpha;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.SolidColor.prototype._alpha = 1.0;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.SolidColor.prototype._color = 0x000000;


/**
 * addFillAttrib()
 *
 * @asparam value The IGraphicShape object on which the fill must be added.
 * @asreturn {string}
 * @export
 * @param {org.apache.flex.graphics.IGraphicShape} value
 * @return {string}
 */
org.apache.flex.graphics.SolidColor.prototype.addFillAttrib = function(value) {
  return 'fill:' + org.apache.flex.utils.CSSUtils.attributeFromColor(this.color) + ';fill-opacity:' + this.alpha;
};


Object.defineProperties(org.apache.flex.graphics.SolidColor.prototype, /** @lends {org.apache.flex.graphics.SolidColor.prototype} */ {
/** @export */
alpha: {
get: /** @this {org.apache.flex.graphics.SolidColor} */ function() {
  return this._alpha;
},
set: /** @this {org.apache.flex.graphics.SolidColor} */ function(value) {
  var /** @type {number} */ oldValue = this._alpha;
  if (value != oldValue) {
    this._alpha = value;
  }
}},
/** @export */
color: {
get: /** @this {org.apache.flex.graphics.SolidColor} */ function() {
  return this._color;
},
set: /** @this {org.apache.flex.graphics.SolidColor} */ function(value) {
  var /** @type {number} */ oldValue = this._color;
  if (value != oldValue) {
    this._color = value;
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.SolidColor.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SolidColor', qName: 'org.apache.flex.graphics.SolidColor'}], interfaces: [org.apache.flex.graphics.IFill] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.SolidColor', org.apache.flex.graphics.SolidColor);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.SolidColor.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'alpha': { type: 'Number', declaredBy: 'org.apache.flex.graphics.SolidColor'},
        'color': { type: 'uint', declaredBy: 'org.apache.flex.graphics.SolidColor'}
      };
    },
    methods: function () {
      return {
        'SolidColor': { type: '', declaredBy: 'org.apache.flex.graphics.SolidColor'},
        'addFillAttrib': { type: 'String', declaredBy: 'org.apache.flex.graphics.SolidColor'}
      };
    }
  };
};