/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/QuadraticCurve.as
 * org.apache.flex.graphics.QuadraticCurve
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.QuadraticCurve');

goog.require('org.apache.flex.graphics.IPathCommand');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.graphics.IPathCommand}
 * @param {number} controlX
 * @param {number} controlY
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.flex.graphics.QuadraticCurve = function(controlX, controlY, anchorX, anchorY) {
  this._controlX = controlX;
  this._controlY = controlY;
  this._anchorX = anchorX;
  this._anchorY = anchorY;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.QuadraticCurve.prototype._controlX;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.QuadraticCurve.prototype._controlY;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.QuadraticCurve.prototype._anchorX;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.QuadraticCurve.prototype._anchorY;


/**
 * @export
 * @return {string}
 */
org.apache.flex.graphics.QuadraticCurve.prototype.toString = function() {
  return ["Q", this._controlX, this._controlY, this._anchorX, this._anchorY].join(" ");
};


/**
 * @export
 * @param {Object} ctx
 */
org.apache.flex.graphics.QuadraticCurve.prototype.execute = function(ctx) {
  ctx.quadraticCurveTo(this._controlX, this._controlY, this._anchorX, this._anchorY);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.QuadraticCurve.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'QuadraticCurve', qName: 'org.apache.flex.graphics.QuadraticCurve'}], interfaces: [org.apache.flex.graphics.IPathCommand] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.QuadraticCurve', org.apache.flex.graphics.QuadraticCurve);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.QuadraticCurve.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'QuadraticCurve': { type: '', declaredBy: 'org.apache.flex.graphics.QuadraticCurve'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.graphics.QuadraticCurve'},
        'execute': { type: 'void', declaredBy: 'org.apache.flex.graphics.QuadraticCurve'}
      };
    }
  };
};