/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/CubicCurve.as
 * org.apache.flex.graphics.CubicCurve
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.CubicCurve');

goog.require('org.apache.flex.graphics.IPathCommand');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.graphics.IPathCommand}
 * @param {number} controlX1
 * @param {number} controlY1
 * @param {number} controlX2
 * @param {number} controlY2
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.flex.graphics.CubicCurve = function(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY) {
  this._controlX1 = controlX1;
  this._controlY1 = controlY1;
  this._controlX2 = controlX2;
  this._controlY2 = controlY2;
  this._anchorX = anchorX;
  this._anchorY = anchorY;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.CubicCurve.prototype._controlX1;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.CubicCurve.prototype._controlY1;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.CubicCurve.prototype._controlX2;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.CubicCurve.prototype._controlY2;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.CubicCurve.prototype._anchorX;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.CubicCurve.prototype._anchorY;


/**
 * @export
 * @return {string}
 */
org.apache.flex.graphics.CubicCurve.prototype.toString = function() {
  return ["C", this._controlX1, this._controlY1, this._controlX2, this._controlY2, this._anchorX, this._anchorY].join(" ");
};


/**
 * @export
 * @param {Object} ctx
 */
org.apache.flex.graphics.CubicCurve.prototype.execute = function(ctx) {
  ctx.bezierCurveTo(this._controlX1, this._controlY1, this._controlX2, this._controlY2, this._anchorX, this._anchorY);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.CubicCurve.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CubicCurve', qName: 'org.apache.flex.graphics.CubicCurve'}], interfaces: [org.apache.flex.graphics.IPathCommand] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.CubicCurve', org.apache.flex.graphics.CubicCurve);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.CubicCurve.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'CubicCurve': { type: '', declaredBy: 'org.apache.flex.graphics.CubicCurve'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.graphics.CubicCurve'},
        'execute': { type: 'void', declaredBy: 'org.apache.flex.graphics.CubicCurve'}
      };
    }
  };
};