/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/maps/google/models/MapModel.as
 * org.apache.flex.maps.google.models.MapModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.maps.google.models.MapModel');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBeadModel');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBeadModel}
 */
org.apache.flex.maps.google.models.MapModel = function() {
  org.apache.flex.maps.google.models.MapModel.base(this, 'constructor');
};
goog.inherits(org.apache.flex.maps.google.models.MapModel, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.maps.google.models.MapModel.prototype._strand;


/**
 * @private
 * @type {string}
 */
org.apache.flex.maps.google.models.MapModel.prototype._token;


/**
 * @private
 * @type {google.maps.LatLng}
 */
org.apache.flex.maps.google.models.MapModel.prototype._currentCenter;


/**
 * @private
 * @type {google.maps.Marker}
 */
org.apache.flex.maps.google.models.MapModel.prototype._selectedMarker;


/**
 * @private
 * @type {number}
 */
org.apache.flex.maps.google.models.MapModel.prototype._zoom;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.maps.google.models.MapModel.prototype._searchResults;


Object.defineProperties(org.apache.flex.maps.google.models.MapModel.prototype, /** @lends {org.apache.flex.maps.google.models.MapModel.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.maps.google.models.MapModel} */ function(value) {
  this._strand = value;
}},
/** @export */
token: {
get: /** @this {org.apache.flex.maps.google.models.MapModel} */ function() {
  return this._token;
},
set: /** @this {org.apache.flex.maps.google.models.MapModel} */ function(value) {
  this._token = value;
  this.dispatchEvent(new org.apache.flex.events.Event("tokenChanged"));
}},
/** @export */
currentCenter: {
get: /** @this {org.apache.flex.maps.google.models.MapModel} */ function() {
  return this._currentCenter;
},
set: /** @this {org.apache.flex.maps.google.models.MapModel} */ function(value) {
  this._currentCenter = value;
  this.dispatchEvent(new org.apache.flex.events.Event("currentCenterChanged"));
}},
/** @export */
selectedMarker: {
get: /** @this {org.apache.flex.maps.google.models.MapModel} */ function() {
  return this._selectedMarker;
},
set: /** @this {org.apache.flex.maps.google.models.MapModel} */ function(value) {
  this._selectedMarker = value;
  this.dispatchEvent(new org.apache.flex.events.Event("selectedMarkerChanged"));
}},
/** @export */
zoom: {
get: /** @this {org.apache.flex.maps.google.models.MapModel} */ function() {
  return this._zoom;
},
set: /** @this {org.apache.flex.maps.google.models.MapModel} */ function(value) {
  if (value != this._zoom) {
    this._zoom = value;
    this.dispatchEvent(new org.apache.flex.events.Event("zoomChanged"));
  }
}},
/** @export */
searchResults: {
get: /** @this {org.apache.flex.maps.google.models.MapModel} */ function() {
  return this._searchResults;
},
set: /** @this {org.apache.flex.maps.google.models.MapModel} */ function(value) {
  this._searchResults = value;
  this.dispatchEvent(new org.apache.flex.events.Event("searchResultsChanged"));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.maps.google.models.MapModel.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'MapModel', qName: 'org.apache.flex.maps.google.models.MapModel'}], interfaces: [org.apache.flex.core.IBeadModel] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.maps.google.models.MapModel', org.apache.flex.maps.google.models.MapModel);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.maps.google.models.MapModel.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.maps.google.models.MapModel'},
        'token': { type: 'String', declaredBy: 'org.apache.flex.maps.google.models.MapModel'},
        'currentCenter': { type: 'LatLng', declaredBy: 'org.apache.flex.maps.google.models.MapModel'},
        'selectedMarker': { type: 'Marker', declaredBy: 'org.apache.flex.maps.google.models.MapModel'},
        'zoom': { type: 'Number', declaredBy: 'org.apache.flex.maps.google.models.MapModel'},
        'searchResults': { type: 'Array', declaredBy: 'org.apache.flex.maps.google.models.MapModel'}
      };
    },
    methods: function () {
      return {
        'MapModel': { type: '', declaredBy: 'org.apache.flex.maps.google.models.MapModel'}
      };
    }
  };
};