/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/StreetViewPanorama.as
 * google.maps.StreetViewPanorama
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.StreetViewPanorama');



/**
 * @asparam container [(Node|null)] 
 * @asparam opt_opts [(Object<?,string>|google.maps.StreetViewPanoramaOptions|null|undefined)] 
 * @see [google_maps_api_v3_11]
 * @constructor
 * @extends {google.maps.MVCObject}
 * @param {Object} container
 * @param {Object=} opt_opts
 */
google.maps.StreetViewPanorama = function(container, opt_opts) {
  opt_opts = typeof opt_opts !== 'undefined' ? opt_opts : null;
  google.maps.StreetViewPanorama.base(this, 'constructor');
};
goog.inherits(google.maps.StreetViewPanorama, google.maps.MVCObject);


/**
 * @export
 * @type {Array}
 */
google.maps.StreetViewPanorama.prototype.controls;


/**
 * @asparam pov [(google.maps.StreetViewPov|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.StreetViewPov} pov
 * @return {Object}
 */
google.maps.StreetViewPanorama.prototype.setPov = function(pov) {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.StreetViewPov|null)} 
 * @export
 * @return {google.maps.StreetViewPov}
 */
google.maps.StreetViewPanorama.prototype.getPov = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @return {boolean}
 */
google.maps.StreetViewPanorama.prototype.getVisible = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {string} 
 * @export
 * @return {string}
 */
google.maps.StreetViewPanorama.prototype.getPano = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.StreetViewPov|null)} 
 * @export
 * @return {google.maps.StreetViewPov}
 */
google.maps.StreetViewPanorama.prototype.getPhotographerPov = function() {
  return null;
};


/**
 * @asparam zoom [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} zoom
 * @return {Object}
 */
google.maps.StreetViewPanorama.prototype.setZoom = function(zoom) {
  return null;
};


/**
 * @asparam flag [boolean] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {boolean} flag
 * @return {Object}
 */
google.maps.StreetViewPanorama.prototype.setVisible = function(flag) {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.StreetViewPanorama.prototype.getZoom = function() {
  return 0;
};


/**
 * @asparam latLng [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.LatLng} latLng
 * @return {Object}
 */
google.maps.StreetViewPanorama.prototype.setPosition = function(latLng) {
  return null;
};


/**
 * @asparam pano [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} pano
 * @return {Object}
 */
google.maps.StreetViewPanorama.prototype.setPano = function(pano) {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @return {google.maps.LatLng}
 */
google.maps.StreetViewPanorama.prototype.getPosition = function() {
  return null;
};


/**
 * @asparam provider [function (string): (google.maps.StreetViewPanoramaData|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} provider
 * @return {Object}
 */
google.maps.StreetViewPanorama.prototype.registerPanoProvider = function(provider) {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(Array<(google.maps.StreetViewLink|null)>|null)} 
 * @export
 * @return {Array}
 */
google.maps.StreetViewPanorama.prototype.getLinks = function() {
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.StreetViewPanorama.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'StreetViewPanorama', qName: 'google.maps.StreetViewPanorama'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.StreetViewPanorama', google.maps.StreetViewPanorama);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.StreetViewPanorama.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'controls': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'StreetViewPanorama': { type: '', declaredBy: 'google.maps.StreetViewPanorama'},
        'setPov': { type: 'Object', declaredBy: 'google.maps.StreetViewPanorama'},
        'getPov': { type: 'google.maps.StreetViewPov', declaredBy: 'google.maps.StreetViewPanorama'},
        'getVisible': { type: 'Boolean', declaredBy: 'google.maps.StreetViewPanorama'},
        'getPano': { type: 'String', declaredBy: 'google.maps.StreetViewPanorama'},
        'getPhotographerPov': { type: 'google.maps.StreetViewPov', declaredBy: 'google.maps.StreetViewPanorama'},
        'setZoom': { type: 'Object', declaredBy: 'google.maps.StreetViewPanorama'},
        'setVisible': { type: 'Object', declaredBy: 'google.maps.StreetViewPanorama'},
        'getZoom': { type: 'Number', declaredBy: 'google.maps.StreetViewPanorama'},
        'setPosition': { type: 'Object', declaredBy: 'google.maps.StreetViewPanorama'},
        'setPano': { type: 'Object', declaredBy: 'google.maps.StreetViewPanorama'},
        'getPosition': { type: 'google.maps.LatLng', declaredBy: 'google.maps.StreetViewPanorama'},
        'registerPanoProvider': { type: 'Object', declaredBy: 'google.maps.StreetViewPanorama'},
        'getLinks': { type: 'Array', declaredBy: 'google.maps.StreetViewPanorama'}
      };
    }
  };
};