/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/MVCObject.as
 * google.maps.MVCObject
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.MVCObject');



/**
 * @see [google_maps_api_v3_11]
 * @constructor
 */
google.maps.MVCObject = function() {
  ;
  this._dictionary = new Object();
};


/**
 * @private
 * @type {Object}
 */
google.maps.MVCObject.prototype._dictionary;


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @return {Object}
 */
google.maps.MVCObject.prototype.unbindAll = function() {
  return undefined;
};


/**
 * @asparam key [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {*} 
 * @export
 * @param {string} key
 * @return {*}
 */
google.maps.MVCObject.prototype.get = function(key) {
  if (this._dictionary.hasOwnProperty(key)) {
    return this._dictionary[key];
  } else {
    return undefined;
  }
};


/**
 * @asparam values [(Object|null|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} values
 * @return {Object}
 */
google.maps.MVCObject.prototype.setValues = function(values) {
  for (var /** @type {string} */ id in values) {
    this._dictionary[id] = values[id];
  }
  return undefined;
};


/**
 * @asparam key [string] 
 * @asparam value [?] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} key
 * @param {Object} value
 * @return {Object}
 */
google.maps.MVCObject.prototype.set = function(key, value) {
  this._dictionary[key] = value;
  return undefined;
};


/**
 * @asparam key [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} key
 * @return {Object}
 */
google.maps.MVCObject.prototype.notify = function(key) {
  return null;
};


/**
 * @asparam key [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} key
 * @return {Object}
 */
google.maps.MVCObject.prototype.unbind = function(key) {
  return null;
};


/**
 * @asparam key [string] 
 * @asparam target [(google.maps.MVCObject|null)] 
 * @asparam opt_targetKey [(null|string|undefined)] 
 * @asparam opt_noNotify [(boolean|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} key
 * @param {google.maps.MVCObject} target
 * @param {string=} opt_targetKey
 * @param {boolean=} opt_noNotify
 * @return {Object}
 */
google.maps.MVCObject.prototype.bindTo = function(key, target, opt_targetKey, opt_noNotify) {
  opt_targetKey = typeof opt_targetKey !== 'undefined' ? opt_targetKey : '';
  opt_noNotify = typeof opt_noNotify !== 'undefined' ? opt_noNotify : false;
  return null;
};


/**
 * @asparam eventName [string] 
 * @asparam handler [Function] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.MapsEventListener|null)} 
 * @export
 * @param {string} eventName
 * @param {Function} handler
 * @return {google.maps.MapsEventListener}
 */
google.maps.MVCObject.prototype.addListener = function(eventName, handler) {
  return null;
};


/**
 * @asparam key [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} key
 * @return {Object}
 */
google.maps.MVCObject.prototype.changed = function(key) {
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.MVCObject.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'MVCObject', qName: 'google.maps.MVCObject'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.MVCObject', google.maps.MVCObject);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.MVCObject.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'MVCObject': { type: '', declaredBy: 'google.maps.MVCObject'},
        'unbindAll': { type: 'Object', declaredBy: 'google.maps.MVCObject'},
        'get': { type: '*', declaredBy: 'google.maps.MVCObject'},
        'setValues': { type: 'Object', declaredBy: 'google.maps.MVCObject'},
        'set': { type: 'Object', declaredBy: 'google.maps.MVCObject'},
        'notify': { type: 'Object', declaredBy: 'google.maps.MVCObject'},
        'unbind': { type: 'Object', declaredBy: 'google.maps.MVCObject'},
        'bindTo': { type: 'Object', declaredBy: 'google.maps.MVCObject'},
        'addListener': { type: 'google.maps.MapsEventListener', declaredBy: 'google.maps.MVCObject'},
        'changed': { type: 'Object', declaredBy: 'google.maps.MVCObject'}
      };
    }
  };
};