/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/flat/RadioButton.as
 * org.apache.flex.flat.RadioButton
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.flat.RadioButton');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.flat.RadioButton = function() {
  org.apache.flex.flat.RadioButton.base(this, 'constructor');
};
goog.inherits(org.apache.flex.flat.RadioButton, org.apache.flex.core.UIBase);


/**
 * @export
 * @type {number}
 */
org.apache.flex.flat.RadioButton.radioCounter = 0;


/**
 * @private
 * @type {HTMLInputElement}
 */
org.apache.flex.flat.RadioButton.prototype.input;


/**
 * @private
 * @type {HTMLSpanElement}
 */
org.apache.flex.flat.RadioButton.prototype.radio;


/**
 * @private
 * @type {Text}
 */
org.apache.flex.flat.RadioButton.prototype.textNode;


/**
 * @private
 * @type {HTMLLabelElement}
 */
org.apache.flex.flat.RadioButton.prototype.labelFor;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion HTMLInputElement
 * @flexjsignorecoercion HTMLSpanElement
 * @flexjsignorecoercion HTMLLabelElement
 * @protected
 * @override
 */
org.apache.flex.flat.RadioButton.prototype.createElement = function() {
  this.input = document.createElement('input');
  this.input.type = 'radio';
  this.input.className = 'radio-input';
  this.input.id = '_radio_' + org.apache.flex.flat.RadioButton.radioCounter++;
  this.input.addEventListener('change', org.apache.flex.utils.Language.closure(this.selectionChangeHandler, this, 'selectionChangeHandler'), false);
  this.radio = document.createElement('span');
  this.radio.className = 'radio-icon';
  this.radio.addEventListener('mouseover', org.apache.flex.utils.Language.closure(this.mouseOverHandler, this, 'mouseOverHandler'), false);
  this.radio.addEventListener('mouseout', org.apache.flex.utils.Language.closure(this.mouseOutHandler, this, 'mouseOutHandler'), false);
  this.textNode = org.apache.flex.utils.Language.as(document.createTextNode('radio button'), Text);
  this.labelFor = document.createElement('label');
  this.labelFor.appendChild(this.input);
  this.labelFor.appendChild(this.radio);
  this.labelFor.appendChild(this.textNode);
  this.labelFor.style.position = 'relative';
  this.element = this.labelFor;
  this.element.className = 'RadioButton';
  this.typeNames = 'RadioButton';
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.input.flexjs_wrapper = this;
  this.radio.flexjs_wrapper = this;
  this.element.flexjs_wrapper = this;
  this.textNode.flexjs_wrapper = this;
  return this.element;
};


/**
 * @asparam e The event object.
 * @private
 * @param {Event} e
 */
org.apache.flex.flat.RadioButton.prototype.mouseOverHandler = function(e) {
  this.radio.className = 'radio-icon-hover';
};


/**
 * @asparam e The event object.
 * @private
 * @param {Event} e
 */
org.apache.flex.flat.RadioButton.prototype.mouseOutHandler = function(e) {
  if (this.input.checked)
    this.radio.className = 'radio-icon-checked';
  else
    this.radio.className = 'radio-icon';
};


/**
 * @asparam e The event object.
 * @private
 * @param {Event} e
 */
org.apache.flex.flat.RadioButton.prototype.selectionChangeHandler = function(e) {
  this.selectedValue = this.value;
};


Object.defineProperties(org.apache.flex.flat.RadioButton.prototype, /** @lends {org.apache.flex.flat.RadioButton.prototype} */ {
/** @export */
id: {
get: /** @this {org.apache.flex.flat.RadioButton} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.flat.RadioButton, this, 'id');
},
set: /** @this {org.apache.flex.flat.RadioButton} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.flat.RadioButton, this, 'id', value);
  this.labelFor.id = value;
  this.input.id = value;
}},
/** @export */
groupName: {
get: /** @this {org.apache.flex.flat.RadioButton} */ function() {
  return this.input.name;
},
set: /** @this {org.apache.flex.flat.RadioButton} */ function(value) {
  this.input.name = value;
}},
/** @export */
text: {
get: /** @this {org.apache.flex.flat.RadioButton} */ function() {
  return this.textNode.nodeValue;
},
set: /** @this {org.apache.flex.flat.RadioButton} */ function(value) {
  this.textNode.nodeValue = value;
}},
/** @export */
selected: {
get: /** @this {org.apache.flex.flat.RadioButton} */ function() {
  return this.input.checked;
},
set: /** @this {org.apache.flex.flat.RadioButton} */ function(value) {
  this.input.checked = value;
  if (this.input.checked)
    this.radio.className = 'radio-icon-checked';
  else
    this.radio.className = 'radio-icon';
}},
/** @export */
value: {
get: /** @this {org.apache.flex.flat.RadioButton} */ function() {
  return this.input.value;
},
set: /** @this {org.apache.flex.flat.RadioButton} */ function(value) {
  this.input.value = value;
}},
/** @export */
selectedValue: {
get: /** @this {org.apache.flex.flat.RadioButton} */ function() {
  var /** @type {Array} */ buttons;
  var /** @type {string} */ groupName;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  groupName = this.input.name;
  buttons = document.getElementsByName(groupName);
  n = buttons.length;
  for (i = 0; i < n; i++) {
    if (buttons[i].checked) {
      return buttons[i].value;
    }
  }
  return null;
},
set: /** @this {org.apache.flex.flat.RadioButton} */ function(value) {
  var /** @type {Array} */ buttons;
  var /** @type {string} */ groupName;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  groupName = this.input.name;
  buttons = document.getElementsByName(groupName);
  n = buttons.length;
  for (i = 0; i < n; i++) {
    if (buttons[i].value === value) {
      buttons[i].checked = true;
      buttons[i].flexjs_wrapper.selected = true;
    }
    else
      buttons[i].flexjs_wrapper.selected = false;
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.flat.RadioButton.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'RadioButton', qName: 'org.apache.flex.flat.RadioButton'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.flat.RadioButton', org.apache.flex.flat.RadioButton);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.flat.RadioButton.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'id': { type: 'String', declaredBy: 'org.apache.flex.flat.RadioButton'},
        'groupName': { type: 'String', declaredBy: 'org.apache.flex.flat.RadioButton'},
        'text': { type: 'String', declaredBy: 'org.apache.flex.flat.RadioButton'},
        'selected': { type: 'Boolean', declaredBy: 'org.apache.flex.flat.RadioButton'},
        'value': { type: 'String', declaredBy: 'org.apache.flex.flat.RadioButton'},
        'selectedValue': { type: 'Object', declaredBy: 'org.apache.flex.flat.RadioButton'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};