/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/effects/Resize.as
 * org.apache.flex.effects.Resize
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.effects.Resize');

goog.require('org.apache.flex.effects.Tween');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @asparam target Object ID or reference to an object that will
 *  have its x and/or y property animated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @extends {org.apache.flex.effects.Tween}
 * @implements {org.apache.flex.core.IDocument}
 * @param {org.apache.flex.core.IUIBase=} target
 */
org.apache.flex.effects.Resize = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.flex.effects.Resize.base(this, 'constructor');
  this.actualTarget = target;
  this.startValue = 0;
  this.endValue = 1;
  this.listener = this;
};
goog.inherits(org.apache.flex.effects.Resize, org.apache.flex.effects.Tween);


/**
 * @private
 * @type {Object}
 */
org.apache.flex.effects.Resize.prototype.document;


/**
 * @private
 * @type {org.apache.flex.core.IUIBase}
 */
org.apache.flex.effects.Resize.prototype.actualTarget;


/**
 * @export
 * @type {string}
 */
org.apache.flex.effects.Resize.prototype.target;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.widthBy;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.heightBy;


/**
 * @private
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.widthStart;


/**
 * @private
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.heightStart;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.widthFrom;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.heightFrom;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.widthTo;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Resize.prototype.heightTo;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.effects.Resize.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.effects.Resize.prototype.play = function() {
  if (this.target != null)
    this.actualTarget = this.document[this.target];
  if (isNaN(this.widthFrom))
    this.widthStart = this.actualTarget.width;
  if (isNaN(this.widthBy)) {
    if (isNaN(this.widthTo))
      this.widthBy = 0;
    else
      this.widthBy = this.widthTo - this.widthStart;
  }
  if (isNaN(this.heightFrom))
    this.heightStart = this.actualTarget.height;
  if (isNaN(this.heightBy)) {
    if (isNaN(this.heightTo))
      this.heightBy = 0;
    else
      this.heightBy = this.heightTo - this.heightStart;
  }
  org.apache.flex.effects.Resize.base(this, 'play');
};


/**
 * @export
 * @param {number} value
 */
org.apache.flex.effects.Resize.prototype.onTweenUpdate = function(value) {
  if (this.widthBy)
    this.actualTarget.width = this.widthStart + value * this.widthBy;
  if (this.heightBy)
    this.actualTarget.height = this.heightStart + value * this.heightBy;
};


/**
 * @export
 * @param {number} value
 */
org.apache.flex.effects.Resize.prototype.onTweenEnd = function(value) {
  if (this.widthBy)
    this.actualTarget.width = this.widthStart + this.widthBy;
  if (this.heightBy)
    this.actualTarget.height = this.heightStart + this.heightBy;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.effects.Resize.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Resize', qName: 'org.apache.flex.effects.Resize'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.effects.Resize', org.apache.flex.effects.Resize);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.effects.Resize.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'target': { type: 'String'},
        'widthBy': { type: 'Number'},
        'heightBy': { type: 'Number'},
        'widthFrom': { type: 'Number'},
        'heightFrom': { type: 'Number'},
        'widthTo': { type: 'Number'},
        'heightTo': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Resize': { type: '', declaredBy: 'org.apache.flex.effects.Resize'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.effects.Resize'},
        'play': { type: 'void', declaredBy: 'org.apache.flex.effects.Resize'},
        'onTweenUpdate': { type: 'void', declaredBy: 'org.apache.flex.effects.Resize'},
        'onTweenEnd': { type: 'void', declaredBy: 'org.apache.flex.effects.Resize'}
      };
    }
  };
};